/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.annotation.SuppressLint;
import android.location.Location;
import android.location.LocationManager;
import android.util.Log;
import com.cloud.sdk.commonutil.complicance.ComplianceHelper;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class GPSTracker {
    private static Location location;
    private static double latitude;
    private static double longitude;
    private static int accu;
    private static long coordTime;
    private static String coordTimeStr;
    private static final AtomicInteger mFailTimes;

    private GPSTracker() {
        GPSTracker.getLocation();
    }

    public static double getLongitude() {
        if (!ComplianceHelper.isGDPRComplianceEnabled()) {
            return 0.0;
        }
        GPSTracker.updateLocation();
        return longitude;
    }

    public static double getLatitude() {
        if (!ComplianceHelper.isGDPRComplianceEnabled()) {
            return 0.0;
        }
        GPSTracker.updateLocation();
        return latitude;
    }

    public static int getAccu() {
        if (!ComplianceHelper.isGDPRComplianceEnabled()) {
            return 0;
        }
        GPSTracker.updateLocation();
        return accu;
    }

    public static long getCoordTime() {
        GPSTracker.updateLocation();
        return coordTime;
    }

    public static String getCoordTimeStr() {
        GPSTracker.updateLocation();
        return coordTimeStr;
    }

    private static void updateLocation() {
        if (GPSTracker.checkNeedRetry()) {
            GPSTracker.getLocation();
        }
    }

    private static boolean checkNeedRetry() {
        return latitude == 0.0 && longitude == 0.0 && mFailTimes.getAndIncrement() <= 1;
    }

    @SuppressLint(value={"MissingPermission"})
    private static void getLocation() {
        try {
            if (HSCoreUtil.getContext() != null) {
                LocationManager locationManager = (LocationManager)HSCoreUtil.getContext().getSystemService("location");
                boolean isGPSEnabled = locationManager.isProviderEnabled("gps");
                boolean isNetworkEnabled = locationManager.isProviderEnabled("network");
                if (!isGPSEnabled && !isNetworkEnabled) {
                    return;
                }
                boolean canGetLocation = true;
                if (isGPSEnabled && locationManager != null) {
                    location = locationManager.getLastKnownLocation("gps");
                    GPSTracker.updateGPSCoordinates(location);
                }
                if (isNetworkEnabled && location == null && locationManager != null) {
                    location = locationManager.getLastKnownLocation("network");
                    GPSTracker.updateGPSCoordinates(location);
                }
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().d("ssp", "Location Impossible to connect to LocationManager");
        }
        if (location != null) {
            GPSTracker.updateGPSCoordinates(location);
        }
    }

    private static void updateGPSCoordinates(Location location) {
        if (location != null) {
            latitude = location.getLatitude();
            longitude = location.getLongitude();
            accu = (int)location.getAccuracy();
            coordTime = location.getTime();
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS Z");
                Date date = new Date(coordTime);
                coordTimeStr = format.format(date);
            }
            catch (Exception e) {
                CommonLogUtil.Log().e(Log.getStackTraceString((Throwable)e));
            }
        }
    }

    static {
        accu = 0;
        coordTime = 0L;
        coordTimeStr = "";
        mFailTimes = new AtomicInteger(0);
    }
}

