/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.athena;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.cloud.sdk.commonutil.athena.AntiFraudUtil;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class SensorUtil
implements SensorEventListener {
    private final SensorManager mSensorManager;
    private float[] orientationValues = new float[0];
    private float lightValue;
    private float[] magneticFieldValue = new float[0];
    private float proximityValue;
    private float temperatureValue;
    private float[] gyroscopeValue = new float[0];
    private float pressureValue;
    private float[] gravityValue = new float[0];
    private float[] accelerometerValue = new float[0];
    private final AtomicBoolean isFinish = new AtomicBoolean(false);

    public static SensorUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private SensorUtil() {
        this.mSensorManager = (SensorManager)HSCoreUtil.getContext().getSystemService("sensor");
    }

    public void onSensorChanged(SensorEvent event) {
        if (null == event || null == event.sensor || null == event.values || event.values.length < 1) {
            return;
        }
        int sensorType = event.sensor.getType();
        switch (sensorType) {
            case 3: {
                this.orientationValues = event.values;
                break;
            }
            case 5: {
                this.lightValue = event.values[0];
                break;
            }
            case 2: {
                this.magneticFieldValue = event.values;
                break;
            }
            case 8: {
                this.proximityValue = event.values[0];
                break;
            }
            case 7: {
                this.temperatureValue = event.values[0];
                break;
            }
            case 4: {
                this.gyroscopeValue = event.values;
                break;
            }
            case 6: {
                this.pressureValue = event.values[0];
                break;
            }
            case 9: {
                this.gravityValue = event.values;
                break;
            }
            case 1: {
                this.accelerometerValue = event.values;
                break;
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onStart() {
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensorManager.getDefaultSensor(3), 3);
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensorManager.getDefaultSensor(4), 3);
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensorManager.getDefaultSensor(9), 3);
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensorManager.getDefaultSensor(1), 3);
    }

    public void onStop() {
        if (Looper.myLooper() == null) {
            return;
        }
        new Handler(Looper.myLooper()).postDelayed(() -> {
            this.isFinish.set(true);
            this.mSensorManager.unregisterListener((SensorEventListener)this);
        }, 1000L);
    }

    public boolean isFinish() {
        return this.isFinish.get();
    }

    public float[] getOrientationSensor() {
        return this.orientationValues;
    }

    public float getLightSensor() {
        return this.lightValue;
    }

    public float[] getMagneticFieldSensor() {
        return this.magneticFieldValue;
    }

    public float getProximitySensor() {
        return this.proximityValue;
    }

    public float getTemperatureSensor() {
        return this.temperatureValue;
    }

    public float[] getGyroscopeSensor() {
        return this.gyroscopeValue;
    }

    public float getPressureSensor() {
        return this.pressureValue;
    }

    public float[] getGravitySensor() {
        return this.gravityValue;
    }

    public float[] getAccelerometerSensor() {
        return this.accelerometerValue;
    }

    public static void register() {
        try {
            SensorUtil.getInstance().onStart();
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        finally {
            try {
                SensorUtil.getInstance().onStop();
            }
            catch (Exception e) {
                AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
            }
        }
    }

    public static Bundle getSensorBundle() {
        Bundle bundle = new Bundle();
        try {
            bundle.putFloatArray("ots", SensorUtil.getInstance().getOrientationSensor());
            bundle.putFloat("ls", SensorUtil.getInstance().getLightSensor());
            bundle.putFloatArray("ms", SensorUtil.getInstance().getMagneticFieldSensor());
            bundle.putFloat("pxs", SensorUtil.getInstance().getProximitySensor());
            bundle.putFloat("tps", SensorUtil.getInstance().getTemperatureSensor());
            bundle.putFloatArray("gs", SensorUtil.getInstance().getGyroscopeSensor());
            bundle.putFloat("pss", SensorUtil.getInstance().getPressureSensor());
            bundle.putFloatArray("gvs", SensorUtil.getInstance().getGravitySensor());
            bundle.putFloatArray("ams", SensorUtil.getInstance().getAccelerometerSensor());
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return bundle;
    }

    private static class SingletonHolder {
        private static final SensorUtil INSTANCE = new SensorUtil();

        private SingletonHolder() {
        }
    }
}

