/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.athena;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.sdk.commonutil.athena.PostConstant;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.GPSTracker;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import com.cloud.sdk.commonutil.util.HSScopeHelper;
import com.transsion.ga.AthenaAnalytics;
import java.util.List;

public class AthenaUtil {
    public static String vaid;

    public static void trackInNewThread(Runnable runnable) {
        HSScopeHelper.INSTANCE.runIoJob(runnable);
    }

    public static Bundle getBundle(Bundle bundle) {
        long start = 0L;
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("session_id", PostConstant.getSessionId());
        bundle.putString("sdk_version", PostConstant.getSdkVersion());
        bundle.putInt("sdk_version_int", PostConstant.getSdkVersionCode());
        bundle.putString("user_agent", PostConstant.getUserAgent());
        bundle.putInt("type", PostConstant.getType());
        bundle.putString("make", PostConstant.getMake());
        bundle.putString("ostype", "Android");
        bundle.putInt("screen_width", PostConstant.getScreenWidth());
        bundle.putInt("screen_height", PostConstant.getScreenHeight());
        bundle.putInt("screen_density", PostConstant.getScreenDensity());
        bundle.putString("base_station", DeviceUtil.getGsmCellLocation());
        bundle.putDouble("latitude", GPSTracker.getLatitude());
        bundle.putDouble("longitude", GPSTracker.getLongitude());
        bundle.putLong("coordtime", GPSTracker.getCoordTime());
        bundle.putString("oneid", DeviceUtil.getOneId());
        bundle.putInt("turn_off_per_ads", DeviceUtil.getGaidStatus());
        if (TextUtils.isEmpty((CharSequence)vaid)) {
            try {
                vaid = AthenaAnalytics.getAppVAID((Context)HSCoreUtil.getContext(), (boolean)true);
            }
            catch (Exception e) {
                CommonLogUtil.Log().e("ssp", "getAppVAID " + Log.getStackTraceString((Throwable)e));
            }
        }
        bundle.putString("vaid", vaid);
        bundle.putString("gaid", DeviceUtil.getGAId());
        return bundle;
    }

    public static boolean isNeedTrack(List<String> logEnable, String value) {
        if (logEnable == null || logEnable.isEmpty()) {
            return false;
        }
        return logEnable.contains(value);
    }
}

