/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

public class DbThread {
    private static final String WORK_THREAD_NAME = "h_db_thread";
    private final Handler mWorkHandler;

    private DbThread() {
        HandlerThread workThread = new HandlerThread(WORK_THREAD_NAME);
        workThread.start();
        this.mWorkHandler = new Handler(workThread.getLooper());
    }

    public void post(Runnable runnable) {
        try {
            if (this.mWorkHandler != null && runnable != null) {
                if (this.mWorkHandler.getLooper().equals(Looper.myLooper())) {
                    runnable.run();
                    return;
                }
                this.mWorkHandler.post(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void postDelay(Runnable runnable, long time) {
        if (this.mWorkHandler != null && runnable != null) {
            this.mWorkHandler.postDelayed(runnable, time);
        }
    }

    public static DbThread getInstance() {
        return WorkThreadHolder.INSTANCE;
    }

    private static class WorkThreadHolder {
        private static final DbThread INSTANCE = new DbThread();

        private WorkThreadHolder() {
        }
    }
}

