/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.pool;

import com.cloud.sdk.commonutil.pool.HSPoolExecutor;
import com.cloud.sdk.commonutil.pool.HSPoolManagerImpl;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadPoolExecutor;

public class HSHttpPoolManager
implements HSPoolManagerImpl {
    private static volatile HSHttpPoolManager mInstance;
    private ThreadPoolExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HSHttpPoolManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<HSHttpPoolManager> var0 = HSHttpPoolManager.class;
        Class<HSHttpPoolManager> clazz = HSHttpPoolManager.class;
        synchronized (HSHttpPoolManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new HSHttpPoolManager();
            HSHttpPoolManager.mInstance.executor = HSPoolExecutor.newSourceExecutor();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    @Override
    public void addTask(Runnable newTask) {
        if (this.executor != null) {
            if (this.executor.isShutdown()) {
                this.executor.prestartAllCoreThreads();
            }
            this.executor.execute(newTask);
        }
    }

    @Override
    public void destroy() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    @Override
    public void purge() {
        if (this.executor != null) {
            this.executor.purge();
        }
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public void execute(WeakReference<Runnable> request) {
        Runnable runnable = (Runnable)request.get();
        if (runnable != null) {
            this.addTask(runnable);
        }
    }
}

