/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u000e\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0007J\u0006\u0010\u0011\u001a\u00020\u0006J\b\u0010\u0012\u001a\u00020\tH\u0007J$\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/cloud/sdk/commonutil/util/HisavanaImageLoader;", "", "()V", "TAG", "", "isContainGlide", "", "isUseGlide", "bindDrawable", "", "drawable", "Landroid/graphics/drawable/Drawable;", "imageView", "Landroid/widget/ImageView;", "destroyImageView", "gifToDrawable", "data", "hasGlide", "initGlideStatus", "loadImageWithGlide", "url", "highPriority", "setUseGlide", "useGlide", "commonutil_release"})
public final class HisavanaImageLoader {
    @NotNull
    public static final HisavanaImageLoader INSTANCE = new HisavanaImageLoader();
    @NotNull
    private static final String TAG = "HisavanaImageLoader";
    private static boolean isContainGlide;
    private static boolean isUseGlide;

    private HisavanaImageLoader() {
    }

    @JvmStatic
    public static final void initGlideStatus() {
        try {
            if (Class.forName("com.bumptech.glide.Glide") != null) {
                isContainGlide = true;
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e("ssp", "init glide error, com.bumptech.glide.Glide not found!");
        }
    }

    public final boolean hasGlide() {
        return isContainGlide;
    }

    @JvmStatic
    public static final void setUseGlide(boolean useGlide) {
        isUseGlide = useGlide;
    }

    @JvmStatic
    public static final boolean loadImageWithGlide(@Nullable String url, @Nullable ImageView imageView, boolean highPriority) {
        try {
            CharSequence charSequence = url;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || imageView == null || !INSTANCE.hasGlide() || !isUseGlide) {
                return false;
            }
            BaseRequestOptions baseRequestOptions = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE);
            Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions, (String)"RequestOptions().diskCac\u2026y(DiskCacheStrategy.NONE)");
            RequestOptions options = (RequestOptions)baseRequestOptions;
            if (highPriority) {
                BaseRequestOptions baseRequestOptions2 = ((RequestOptions)options.useUnlimitedSourceGeneratorsPool(true)).priority(Priority.IMMEDIATE);
                Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions2, (String)"options.useUnlimitedSour\u2026ority(Priority.IMMEDIATE)");
                options = (RequestOptions)baseRequestOptions2;
            }
            Glide.with((Context)HSCoreUtil.getContext()).load(url).apply((BaseRequestOptions)options).into(imageView);
        }
        catch (Throwable e) {
            CommonLogUtil.Log().w(TAG, "Glide\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final void destroyImageView(@Nullable ImageView imageView) {
        try {
            if (imageView != null && imageView.getDrawable() != null && !INSTANCE.hasGlide()) {
                if (imageView.getDrawable() instanceof BitmapDrawable) {
                    Bitmap bitmap;
                    BitmapDrawable drawable;
                    Drawable drawable2 = imageView.getDrawable();
                    BitmapDrawable bitmapDrawable = drawable = drawable2 instanceof BitmapDrawable ? (BitmapDrawable)drawable2 : null;
                    if (drawable != null && (bitmap = drawable.getBitmap()) != null && !bitmap.isRecycled()) {
                        bitmap.recycle();
                    }
                } else {
                    imageView.setImageDrawable(null);
                }
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().w(TAG, "destroyImageView error msg = " + e.getMessage());
        }
    }

    @JvmStatic
    @Nullable
    public static final Drawable gifToDrawable(@Nullable Object data) {
        if (data == null) {
            return null;
        }
        if (!INSTANCE.hasGlide() || !isUseGlide) {
            Bitmap bitmap;
            Bitmap bitmap2 = bitmap = data instanceof byte[] ? BitmapFactory.decodeByteArray((byte[])((byte[])data), (int)0, (int)((byte[])data).length) : null;
            if (bitmap == null) {
                return null;
            }
            return (Drawable)new BitmapDrawable(HSCoreUtil.getContext().getResources(), bitmap);
        }
        Drawable result = null;
        try {
            result = (Drawable)((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)HSCoreUtil.getContext()).asGif().useUnlimitedSourceGeneratorsPool(true)).priority(Priority.IMMEDIATE)).diskCacheStrategy(DiskCacheStrategy.NONE)).load(data).submit().get();
        }
        catch (InterruptedException e) {
            CommonLogUtil.Log().d(TAG, "gif to drawable error, error msg = " + e.getMessage());
        }
        CommonLogUtil.Log().i(TAG, "load result = " + (result != null));
        return result;
    }

    @JvmStatic
    public static final void bindDrawable(@Nullable Drawable drawable, @Nullable ImageView imageView) {
        if (drawable == null || imageView == null) {
            return;
        }
        imageView.setImageDrawable(drawable);
        if (!INSTANCE.hasGlide() || !isUseGlide) {
            return;
        }
        CommonLogUtil.Log().i(TAG, "use glide drawable is GifDrawable = " + (drawable instanceof GifDrawable));
        if (drawable instanceof GifDrawable) {
            ((GifDrawable)drawable).start();
        }
    }

    static {
        isUseGlide = true;
    }
}

