/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.cloud.sdk.commonutil.util.HSCoreUtil;

public class MitNetUtil {
    private static final String TAG = "MitNetUtil";

    public static String getOperatorName() {
        if (HSCoreUtil.getContext().getApplicationContext() != null) {
            TelephonyManager telephonyManager = (TelephonyManager)HSCoreUtil.getContext().getApplicationContext().getSystemService("phone");
            return telephonyManager.getSimOperatorName();
        }
        return "";
    }

    public static boolean isNetworkAvailable(Context context) {
        block6: {
            if (context == null) {
                return false;
            }
            ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            if (cm == null) {
                return false;
            }
            try {
                if (Build.VERSION.SDK_INT >= 23) {
                    NetworkCapabilities networkCapabilities;
                    Network activeNetwork = cm.getActiveNetwork();
                    if (activeNetwork != null && (networkCapabilities = cm.getNetworkCapabilities(activeNetwork)) != null) {
                        return networkCapabilities.hasTransport(1) || networkCapabilities.hasTransport(0) || networkCapabilities.hasTransport(4) || networkCapabilities.hasTransport(3);
                    }
                    break block6;
                }
                NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                return networkInfo != null && networkInfo.isConnected();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
        }
        return false;
    }

    public static NetworkType getNetworkType(Context context) {
        if (null == context) {
            return NetworkType.NETWORK_UNKNOWN;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (cm == null) {
            return NetworkType.NETWORK_UNKNOWN;
        }
        try {
            NetworkInfo.State state;
            NetworkInfo networkInfo = cm.getNetworkInfo(1);
            if (networkInfo != null && ((state = networkInfo.getState()) == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
                return NetworkType.NETWORK_WIFI;
            }
            networkInfo = cm.getNetworkInfo(9);
            if (networkInfo != null && ((state = networkInfo.getState()) == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
                return NetworkType.NETWORK_ETHERNET;
            }
            networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isAvailable()) {
                if (networkInfo.getType() == 0) {
                    switch (networkInfo.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: 
                        case 16: {
                            return NetworkType.NETWORK_2G;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: 
                        case 17: {
                            return NetworkType.NETWORK_3G;
                        }
                        case 13: 
                        case 18: {
                            return NetworkType.NETWORK_4G;
                        }
                        case 20: {
                            return NetworkType.NETWORK_5G;
                        }
                    }
                    String subtypeName = networkInfo.getSubtypeName();
                    if (subtypeName.equalsIgnoreCase("TD-SCDMA") || subtypeName.equalsIgnoreCase("WCDMA") || subtypeName.equalsIgnoreCase("CDMA2000")) {
                        return NetworkType.NETWORK_3G;
                    }
                    return NetworkType.NETWORK_UNKNOWN;
                }
                return NetworkType.NETWORK_UNKNOWN;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        return NetworkType.NETWORK_UNKNOWN;
    }

    public static enum NetworkType {
        NETWORK_UNKNOWN,
        NETWORK_WIFI,
        NETWORK_2G,
        NETWORK_3G,
        NETWORK_4G,
        NETWORK_5G,
        NETWORK_ETHERNET;

    }
}

