package com.cloud.sdk.commonutil.control;


import android.os.Build;
import android.text.TextUtils;

import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.HSSharedPreferencesUtil;

import java.util.HashSet;
import java.util.Set;

/**
 * Created by peng.sun on 2017/6/29.
 */

public class AdxPreferencesHelper {
    private static final String TAG = "AdxPreferencesHelper";
    /**
     * 需要操作的文件名，广告的SDk默认名称
     */
    private static final String SP_NAME = "hisavana_sdk";
    private static final AdxPreferencesHelper INSTANCE = new AdxPreferencesHelper();
    private HisavanaMMKV hisavanaMMKV;

    private AdxPreferencesHelper() {
        try {
            Class<?> c = Class.forName("com.tencent.mmkv.MMKV");
            if (c == null) {
                CommonLogUtil.Log().w(TAG,"mmkv is not implementation");
                return;
            }
            //2.0以下版本不适配target 35
            if (Build.VERSION.SDK_INT >= 35 &&
                    (HisavanaMMKV.getInstance().getVersion().startsWith("v1.") || HisavanaMMKV.getInstance().getVersion().startsWith("v0."))) {
                CommonLogUtil.Log().e(TAG,"mmkv is not ajust target 35");
                return;
            }
            hisavanaMMKV = HisavanaMMKV.getInstance();

        } catch (Throwable e) {
            CommonLogUtil.Log().e(TAG,"init mmkv error, com.tencent.mmkv.MMKV not found!");
            hisavanaMMKV = null;
        }
    }

    /**
     * 获得AdxPreferencesHelper实例
     *
     * @return
     */
    public static AdxPreferencesHelper getInstance() {
        return INSTANCE;
    }

    public void clear() {
        if (hisavanaMMKV != null) {
            hisavanaMMKV.clear();
        } else {
            HSSharedPreferencesUtil.getInstance(SP_NAME).clear();
        }
    }
    public void putString(String key, String value) {
        if (hisavanaMMKV == null) {
            HSSharedPreferencesUtil.getInstance(SP_NAME).putString(key, value);
        } else {
            hisavanaMMKV.putString(key, value);
        }
    }

    public String getString(String key, String defaultValue) {
        if (hisavanaMMKV != null) {
            return hisavanaMMKV.getString(key, defaultValue);
        } else {
            return HSSharedPreferencesUtil.getInstance(SP_NAME).getString(key, defaultValue);
        }
    }

    public String getString(String key) {
        return getString(key, "");
    }

    public void putInt(String key, int value) {
        if (hisavanaMMKV != null) {
            hisavanaMMKV.putInt(key, value);
        } else {
            HSSharedPreferencesUtil.getInstance(SP_NAME).putInt(key, value);
        }
    }

    public int getInt(String key, int defaultValue) {
        if (hisavanaMMKV != null) {
            return hisavanaMMKV.getInt(key, defaultValue);
        } else {
            return HSSharedPreferencesUtil.getInstance(SP_NAME).getInt(key, defaultValue);
        }
    }

    public int getInt(String key) {
        return getInt(key, 0);
    }

    public void putBoolean(String key, boolean value) {
        if (hisavanaMMKV != null) {
            hisavanaMMKV.putBoolean(key, value);
        } else {
            HSSharedPreferencesUtil.getInstance(SP_NAME).putBoolean(key, value);
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (hisavanaMMKV != null) {
            return hisavanaMMKV.getBoolean(key, defaultValue);
        } else {
            return HSSharedPreferencesUtil.getInstance(SP_NAME).getBoolean(key, defaultValue);
        }
    }

    public boolean getBoolean(String key) {
        return getBoolean(key, false);
    }

    public void putLong(String key, long value) {
        if (hisavanaMMKV != null) {
            hisavanaMMKV.putLong(key, value);
        } else {
            HSSharedPreferencesUtil.getInstance(SP_NAME).putLong(key, value);
        }
    }

    public long getLong(String key, long defaultValue) {
        if (hisavanaMMKV != null) {
            return hisavanaMMKV.getLong(key, defaultValue);
        } else {
            return HSSharedPreferencesUtil.getInstance(SP_NAME).getLong(key, defaultValue);
        }
    }

    public long getLong(String key) {
        return getLong(key, 0);
    }

    public Set<String> getStringSet(String key, Set<String> defaultValue) {
        if (hisavanaMMKV != null) {
            return hisavanaMMKV.getStringSet(key, defaultValue);
        } else {
            return HSSharedPreferencesUtil.getInstance(SP_NAME).getStringSet(key, defaultValue);
        }
    }

    public Set<String> getStringSet(String key) {
        return getStringSet(key, new HashSet<>());
    }

    /**
     * 根据key来删除对应的值
     * @param key
     */
    public void remove(String key) {
        if(TextUtils.isEmpty(key)){
            return;
        }
        if (hisavanaMMKV != null) {
            hisavanaMMKV.remove(key);
        } else {
            HSSharedPreferencesUtil.getInstance(SP_NAME).remove(key);
        }
    }
}
