package com.cloud.sdk.commonutil.util.imagerender

import android.graphics.drawable.Drawable
import com.cloud.sdk.commonutil.util.CommonLogUtil
import pl.droidsonroids.gif.GifDrawable


object GifDrawableRender: ImageRenderable {

    // gif-drawable 是否可用
    private var available = false

    fun setup() {
        try {
            if (Class.forName("pl.droidsonroids.gif.GifDrawable") != null) {
                available = true
                CommonLogUtil.Log().d(HisavanaImageRender.TAG, "init gif-drawable succeed")
            } else {
                CommonLogUtil.Log().d(HisavanaImageRender.TAG, "init gif-drawable error, cannot found pl.droidsonroids.gif.GifDrawable")
            }
        } catch (e: Throwable) {
            CommonLogUtil.Log().w(HisavanaImageRender.TAG, "init gif-drawable error=${e.message}")
        }
    }

    override fun getGifDrawableFromData(bytes: ByteArray): Drawable? {
        if (!available) {
            return null
        }

        try {
            val result = GifDrawable(bytes)
            CommonLogUtil.Log().d(HisavanaImageRender.TAG, "android-gif-drawable: getGifDrawableFromData succees")
            return result
        } catch (e: Exception) {
            CommonLogUtil.Log().w(HisavanaImageRender.TAG, "android-gif-drawable: getGifDrawableFromData failed, error=${e.message}")
            return null
        }
    }

    override fun activatedDrawable(drawable: Drawable?): Drawable? {
        return drawable
    }
}