/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util.imagerender;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import com.cloud.sdk.commonutil.util.imagerender.ImageRenderable;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R$\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\u0006\"\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/cloud/sdk/commonutil/util/imagerender/GlideRender;", "Lcom/cloud/sdk/commonutil/util/imagerender/ImageRenderable;", "()V", "available", "", "getAvailable", "()Z", "canUseGlide", "getCanUseGlide$annotations", "getCanUseGlide", "setCanUseGlide", "(Z)V", "<set-?>", "isGlideDependency", "activatedDrawable", "Landroid/graphics/drawable/Drawable;", "drawable", "getGifDrawableFromData", "bytes", "", "loadImage", "url", "", "highPriority", "imageView", "Landroid/widget/ImageView;", "setup", "", "commonutil_release"})
public final class GlideRender
implements ImageRenderable {
    @NotNull
    public static final GlideRender INSTANCE = new GlideRender();
    private static boolean isGlideDependency;
    private static boolean canUseGlide;

    private GlideRender() {
    }

    public final boolean isGlideDependency() {
        return isGlideDependency;
    }

    public static final boolean getCanUseGlide() {
        return canUseGlide;
    }

    public static final void setCanUseGlide(boolean bl) {
        canUseGlide = bl;
    }

    @JvmStatic
    public static /* synthetic */ void getCanUseGlide$annotations() {
    }

    private final boolean getAvailable() {
        return isGlideDependency && canUseGlide;
    }

    public final void setup() {
        try {
            if (Class.forName("com.bumptech.glide.Glide") != null) {
                isGlideDependency = true;
                CommonLogUtil.Log().d("HisavanaImageRender", "init glide succeed");
            } else {
                CommonLogUtil.Log().d("HisavanaImageRender", "init glide error, cannot found com.bumptech.glide.Glide");
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().w("HisavanaImageRender", "init glide error=" + e.getMessage());
        }
    }

    @JvmStatic
    public static final boolean loadImage(@Nullable String url, boolean highPriority, @Nullable ImageView imageView) {
        try {
            CharSequence charSequence;
            if (!INSTANCE.getAvailable() || (charSequence = (CharSequence)url) == null || StringsKt.isBlank((CharSequence)charSequence) || imageView == null) {
                return false;
            }
            BaseRequestOptions baseRequestOptions = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE);
            Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions, (String)"diskCacheStrategy(...)");
            RequestOptions options = (RequestOptions)baseRequestOptions;
            if (highPriority) {
                BaseRequestOptions baseRequestOptions2 = ((RequestOptions)options.useUnlimitedSourceGeneratorsPool(true)).priority(Priority.IMMEDIATE);
                Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions2, (String)"priority(...)");
                options = (RequestOptions)baseRequestOptions2;
            }
            Glide.with((Context)HSCoreUtil.getContext()).load(url).apply((BaseRequestOptions)options).into(imageView);
            CommonLogUtil.Log().d("HisavanaImageRender", "loadImage with glide, url=" + url);
        }
        catch (Throwable e) {
            CommonLogUtil.Log().w("HisavanaImageRender", "loadImage with glide failed, error=" + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Drawable getGifDrawableFromData(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            if (!this.getAvailable()) {
                return null;
            }
            GifDrawable result = (GifDrawable)((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)HSCoreUtil.getContext()).asGif().useUnlimitedSourceGeneratorsPool(true)).priority(Priority.IMMEDIATE)).diskCacheStrategy(DiskCacheStrategy.NONE)).load(bytes).submit().get();
            CommonLogUtil.Log().d("HisavanaImageRender", "glide: getGifDrawableFromData succees");
            return (Drawable)result;
        }
        catch (InterruptedException e) {
            CommonLogUtil.Log().w("HisavanaImageRender", "glide: getGifDrawableFromData failed, error=" + e.getMessage());
            return null;
        }
    }

    @Override
    @Nullable
    public Drawable activatedDrawable(@Nullable Drawable drawable) {
        try {
            if (this.getAvailable() && drawable instanceof GifDrawable) {
                ((GifDrawable)drawable).start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return drawable;
    }

    static {
        canUseGlide = true;
    }
}

