package com.cloud.sdk.commonutil.athena;

import android.os.Build;
import android.text.TextUtils;
import com.cloud.sdk.commonutil.BuildConfig;
import com.cloud.sdk.commonutil.deviceinfo.HSDeviceInfo;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.HSScreenUtil;
import com.cloud.sdk.commonutil.util.UserAgentUtil;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by wenjing.luo on 2021/8/24.
 */

public class PostConstant {
    public static final int TID_2411 = 2411;//计费使用该ID上报。目前计费的上报有点击和曝光
    public static final int TID_8765 = 8765; //非计费使用该ID上报athena
    public static final String EVENT_SDK_INIT = "sdk_initalize";
    public static final String EVENT_AD_SHOW = "ad_ssp_show";
    public static final String EVENT_AD_SECOND_WINDOW_SHOW = "ssp_secondwindow_show";
    public static final String EVENT_AD_SECOND_WINDOW_CLICK = "ssp_secondwindow_click";
    public static final String EVENT_SSP_SHOW_DEFAULT= "ssp_show_default";
    public static final String EVENT_SSP_SHOW_INAPP= "ssp_show_inapp";
    public static final String EVENT_IMG = "material_load";

    public static final String EVENT_SLICE_DOWNLOAD = "material_slice_download";
    public static final String EVENT_DEEPLINK = "deeplink";
    public static final String EVENT_AD_SSP_REQUEST = "ad_ssp_request";
    public static final String EVENT_AD_SSP_RETURN = "ad_ssp_return";
    //请求PS素材
    public static final String EVENT_AD_SSP_REQUEST_PS = "ad_ssp_request_ps_material";
    //返回PS素材
    public static final String EVENT_AD_SSP_RETURN_PS = "ad_ssp_return_ps_material";
    //弹窗展现
    public static final String EVENT_AD_PS_POPUP_IMP = "popup_imp";
    //弹窗点击
    public static final String EVENT_AD_PS_POPUP_CLICK = "popup_click";
    //webview重定向
    public static final String EVENT_WEBVIEW_REDIRECT = "ad_web_callback";
    //ssp云控请求
    public static final String EVENT_CLD_REQUEST = "ad_cld_request";
    //ssp云控返回
    public static final String EVENT_CLD_RETURN = "ad_cld_return";
    //form表单离线提交事件
    public static final String EVENT_FORM_INFO_SET = "form_infor_set";
    //点击事件（离线）
    public static final String EVENT_AD_SSP_CLICK= "ad_ssp_click";
    //点击（非加密串）
    public static final String EVENT_SSP_NEW_CLICK= "ssp_new_click";
    public static final String EVENT_SSP_CLICK_DEFAULT= "ssp_click_default";
    public static final String EVENT_SSP_CLICK_INAPP= "ssp_click_inapp";
    //媒体调用请求
    public static final String EVENT_MEDIA_CALL_REQUEST = "media_call_request";
    //填充结果
    public static final String EVENT_AD_FILLING_RESULT = "ad_filling_result";
    //默认广告填充
    public static final String EVENT_SSP_FILLING_RESULT_DEFAULT = "ssp_filling_result_default";
    //关闭广告
    public static final String EVENT_AD_SSP_CLOSE_AD = "ad_ssp_close_ad";
    // 离线 web 加载完成
    public static final String EVENT_AD_WEB_COMPLETE = "ad_web_complete";
    public static final String EVENT_MATERIAL_EXPIRE= "material_expire";//落地页ssl错误信息收集
    //2.6.0.2新增触发展现
    public static final String EVENT_AD_TRIGGER_SHOW = "ssp_trigger_show";
    public static final String EVENT_AD_DEFAULT_TRIGGER_SHOW = "ssp_default_trigger_show";
    //2.6.0.2新增互动事件
    public static final String EVENT_AD_INTERACTION = "interaction_event";
    //记录展示失败的埋点
    public static final String EVENT_AD_SHOW_FAILED = "ssp_show_failed";
    public static final String EVENT_AD_MATERIAL_DOWNLOAD = "ssp_material_download";

    //记录点击链路的埋点
    public static final String EVENT_AD_CLICK_LINK_TRACKING = "ssp_cliclk_link_tracking";

    //记录点击链路的埋点
    public static final String EVENT_AD_LANDING_PAGE_TRACKING = "ssp_landing_page_tracking";
    //记录云控请求的埋点
    public static final String EVENT_TRACK_CLOUD_REQUEST = "track_cloud_request";
    //记录离线请求的埋点
    public static final String EVENT_TRACK_OFFLINE_REQUEST = "track_offline_request";
    //展示过程（插屏互动广告使用）
    public static final String EVENT_SHOW_PROCESS = "show_process";
    public static final String EVENT_AD_FILTER= "ad_filter";//广告返回后过滤
    public static final String JS_BRIDGE_TRIGGER= "js_bridge_trigger";
    public static final String JS_BRIDGE_RESULT= "js_bridge_result";
    public static final String H5_AD_CLICK_PS_REPORTING = "h5_ad_click_ps_reporting";
    //视频广告播放进度
    public static final String EVENT_VIDEO_PROGRESS = "ad_ssp_video_progress";
    public static final String EVENT_VIDEO_PLAY_ERROR = "ad_ssp_video_abnormal";
    public static final String EVENT_VAST_PARSE_ERROR = "ad_ssp_vast_analyze";
    public static final String EVENT_OFFLINE_START_JUDGE = "offline_start_judge";
    public static final String EVENT_OFFLINE_RESULT = "offline_result";
    public static final String EVENT_AGENT_PAGE_JS_WARNING = "agent_page_js_warning";
    public static final String EVENT_SSP_AD_REQUEST_DEFAULT = "ssp_ad_request_default";
    public static final String EVENT_SSP_AD_RETURN_DEFAULT = "ssp_ad_return_default";
    public static final String EVENT_SSP_AD_REQUEST_ZIP = "ssp_ad_request_zip";
    public static final String EVENT_SSP_AD_RETURN_ZIP = "ssp_ad_return_zip";
    public static final String SHOW_ADM_ERROR = "show_adm_error";
    public static final String EVENT_SSP_AD_REWARDED = "ssp_ad_reward";
    // 归因共建
    public static final String IMP_SYNC= "imp_sync";
    public static final String CLICK_SYNC= "click_sync";

    // 小程序提效
    // 小程序加桌引导
    public static final String MINI_APP_ADD_HOMESCREEN_GUIDE = "miniapp_add_homescreen_guide";
    // 小程序系统加桌
    public static final String MINI_APP_SYS_ADD_HOMESCREEN = "miniapp_sys_add_homescreen";

    // Adsense
    public static final String SSP_CONTAINER_OPEN = "ssp_container_open";
    public static final String SSP_CONTAINER_SHOW = "ssp_container_show";
    public static final String SSP_CONTAINER_CLICK = "ssp_container_click";

    public static final String EVENT_ADM_RENDER_PROCESS = "adm_render_process";
    public static final String EVENT_ADX_TRACK_RESULT = "adx_track_result";

    private static String sessionId;
    private static String sdkVersion;
    private static int sdkVersionCode;
    private static String userAgent;
    private static int type = -1;
    private static String make;

    private static int screenWidth = -1;
    private static int screenHeight = -1;
    private static int screenDensity = -1;
    private static String mcc;
    private static String mnc;


    private static String brand;
    private static String model;
    private static String osVersion;
    private static int osApiLevel;
    private static String versionName;
    private static String versionCode;

    private static String cpu;


    /**
     * 本次启动唯一ID：每次启动时生成一个唯一批次号，直到下次启动才变更
     */
    public static String getSessionId() {
        if (TextUtils.isEmpty(sessionId)) sessionId = DeviceUtil.getUUID();
        return sessionId;
    }

    /**
     * sdkVersion
     */
    public static String getSdkVersion(){
        if (TextUtils.isEmpty(sdkVersion)){
            sdkVersion= BuildConfig.NEW_VERSION_NAME;
        }
        return sdkVersion;
    }

    /**
     * sdkVersionCode
     */
    public static int getSdkVersionCode(){
        if (sdkVersionCode == 0){
            sdkVersionCode= BuildConfig.NEW_VERSION_CODE;
        }
        return sdkVersionCode;
    }

    /**
     * 终端用户HTTP请求头中的User-Agent字段
     */
    public static String getUserAgent() {
        if (TextUtils.isEmpty(userAgent)) userAgent = UserAgentUtil.getUserAgent();
        return userAgent;
    }

    /**
     * 设备类型   1=PHONE(手机,含iTouch)
     *          2=TABLET(平板)
     */
    public static int getType() {
        if (type == -1) type = HSDeviceInfo.isPad() ? 2 : 1;
        return type;
    }

    /**
     * 设备制造商
     */
    public static String getMake() {
        if (TextUtils.isEmpty(make)) make = Build.MANUFACTURER;
        return make;
    }

    /**
     * 安卓idSHA1
     */
//    public static String getAndroidIdSha1(){
//        return DeviceUtil.getAndroidIDSHA1();
//    }

    /**
     * 安卓idMd5
     */
//    public static String getAndroidIdMd5(){
//        return DeviceUtil.getAndroidIDMd5();
//    }


    public static int getScreenWidth() {
        if (screenWidth == -1) {
            try{
                screenWidth = HSScreenUtil.getWinWidth();
            }catch (Throwable e){
            }
        }
        return screenWidth;
    }

    public static int getScreenHeight() {
        if (screenHeight == -1) {
            try{
                screenHeight = HSScreenUtil.getWinHeight();
            }catch (Throwable e){}
        }
        return screenHeight;
    }

    public static int getScreenDensity() {
        if (screenDensity == -1) screenDensity = (int) HSScreenUtil.getDensity();
        return screenDensity;
    }

    private static final AtomicInteger mccInteger = new AtomicInteger(0);
    public static String getMcc() {
        if (DeviceUtil.checkCanRetryInTimes(mcc, mccInteger, 1)) {
            String deviceOperator = HSDeviceInfo.getSimOperator();
            if (!TextUtils.isEmpty(deviceOperator) && deviceOperator.length() >= 3) {
                mcc = deviceOperator.substring(0, 3);
            }
        }
        return mcc;
    }

    private static final AtomicInteger mncInteger = new AtomicInteger(0);
    public static String getMnc() {
        if (DeviceUtil.checkCanRetryInTimes(mnc, mncInteger, 1)) {
            String deviceOperator = HSDeviceInfo.getSimOperator();
            if (!TextUtils.isEmpty(deviceOperator) && deviceOperator.length() >= 3) {
                mnc = deviceOperator.substring(3);
            }
        }
        return mnc;
    }

    public static String getBrand() {
        if (TextUtils.isEmpty(brand)) brand = Build.BRAND;
        return brand;
    }

    public static String getModel() {
        if (TextUtils.isEmpty(model)) model = Build.MODEL;
        return model;
    }

    public static String getOsVersion() {
        if (TextUtils.isEmpty(osVersion)) osVersion = DeviceUtil.getSystemVersion();
        return osVersion;
    }

    public static int getOsApiLevel() {
        if (osApiLevel == 0){
            osApiLevel = DeviceUtil.getOsApiLevel();
        }
        return osApiLevel;
    }

    public static String getVersionName() {
        if (TextUtils.isEmpty(versionName)) versionName = String.valueOf(HSCoreUtil.getVersionName());
        return versionName;
    }

    public static String getVersionCode() {
        if (TextUtils.isEmpty(versionCode)) versionCode = String.valueOf(HSCoreUtil.getVersionCode());
        return versionCode;
    }

    public static String getCpu() {
        if (TextUtils.isEmpty(cpu)) cpu = DeviceUtil.getCPU();
        return cpu;
    }
}
