package com.cloud.sdk.commonutil.gsonutil;

import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;

import java.lang.reflect.Type;

/**
 * @author xinbing.zhang
 * @date :2021/12/8 3:02 下午
 * @description:
 */
public class GsonUtil {

    /**
     * 全局统一输出
     */
    public static Gson getGson() {
        //return new Gson();
        return GsonFactory.getSingletonGson();
    }

    /**
     * 数据解析
     */
    public static <T> T fromJson(String json, Class<T> classOfT) throws GsonParseException {
        try {
            return getGson().fromJson(json, classOfT);
        } catch (Exception e) {
            throw new GsonParseException(e);
        }
    }

    public static <T> T fromJson(String json, Type typeOfT) throws GsonParseException {
        try {
            return getGson().fromJson(json, typeOfT);
        } catch (Exception e) {
            throw new GsonParseException(e);
        }
    }

    public static String toJson(Object ob)  {
        try {
            return getGson().toJson(ob);
        } catch (Exception e) {
            CommonLogUtil.Log().e("GsonUtil",e.getMessage());
        }
        return "";
    }

    public static class  GsonParseException extends Exception{
        public GsonParseException(Throwable throwable ){
            super(throwable);
        }
    }
}
