package com.cloud.sdk.commonutil.widget

import android.content.Context
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.graphics.Path
import android.graphics.RectF
import android.util.AttributeSet
import android.view.View
import com.cloud.sdk.commonutil.R

class TranCustomRoundAngleView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : View(context, attrs, defStyleAttr) {

    private val path = Path()
    private val paint = Paint().apply {
        isAntiAlias = true // 开启抗锯齿
        style = Paint.Style.FILL
    }
    private var viewColor: Int = Color.TRANSPARENT

    private var topLeftRadius: Float = 0f
    private var topRightRadius: Float = 0f
    private var bottomLeftRadius: Float = 0f
    private var bottomRightRadius: Float = 0f


    init {
        // 获取在XML中定义的自定义属性
        val typedArray = context.obtainStyledAttributes(attrs, R.styleable.TranCustomRoundAngleView)
        topLeftRadius = typedArray.getDimension(R.styleable.TranCustomRoundAngleView_topLeftRadius, 0f)
        topRightRadius = typedArray.getDimension(R.styleable.TranCustomRoundAngleView_topRightRadius, 0f)
        bottomLeftRadius = typedArray.getDimension(R.styleable.TranCustomRoundAngleView_bottomLeftRadius, 0f)
        bottomRightRadius = typedArray.getDimension(R.styleable.TranCustomRoundAngleView_bottomRightRadius, 0f)
        // 我们新增一个自定义颜色属性，当然您也可以直接使用 android:background
        typedArray.recycle()
        paint.color = viewColor
    }



    override fun onSizeChanged(w: Int, h: Int, oldw: Int, oldh: Int) {
        super.onSizeChanged(w, h, oldw, oldh)
        // 视图大小改变时，重新计算路径
        val rect = RectF(0f, 0f, w.toFloat(), h.toFloat())
        path.reset()
        val radii = floatArrayOf(
            topLeftRadius, topLeftRadius,
            topRightRadius, topRightRadius,
            bottomRightRadius, bottomRightRadius,
            bottomLeftRadius, bottomLeftRadius
        )
        path.addRoundRect(rect, radii, Path.Direction.CW)
    }

    // 关键改动：重写 draw() 方法而不是 dispatchDraw()
    override fun draw(canvas: Canvas) {
        val save = canvas.save() // 保存画布状态
        canvas.clipPath(path)   // 裁剪画布
        super.draw(canvas)      // 让系统继续完成绘制（包括背景和子View）
        canvas.restoreToCount(save) // 恢复画布状态
    }
}