package com.cloud.sdk.commonutil.util

/**
 * 基于 Exception 的异常类。
 *
 */
class HSException : Exception {
    /**
     * 获取错误码。
     */
    var errorCode = -1

    /**
     * 获取异常信息。
     */
    var description = ""
        protected set

    /**
     * 用给定的错误码和异常描述构造一个异常。
     * @param errorCode 错误码。
     * @param desc 异常描述。
     *
     */
    constructor(errorCode: Int, desc: String) : super(desc) {
        this.errorCode = errorCode
        description = desc
    }

    /**
     * 用给定的描述和异常的起因构造一个异常。
     * @param errorCode 错误码。
     * @param desc 异常描述。
     * @param cause 异常起因。
     *
     */
    constructor(errorCode: Int, desc: String?, cause: Throwable?) : super(desc) {
        this.errorCode = errorCode
        super.initCause(cause)
    }

    companion object {
        /** Default for non-checking.  */
        private const val serialVersionUID = 1L
    }
}