package com.cloud.sdk.commonutil.util;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import android.text.TextUtils;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HSSharedPreferencesUtil {
    private static final String TAG = "SharedPreferencesUtil";
    private static Map<String, HSSharedPreferencesUtil> sharePreferBank = new HashMap();
    private SharedPreferences mSharedPreferences;
    private SharedPreferences.Editor mEditor;
    private static final int DEFAULT_INT = 0;
    private static final float DEFAULT_FLOAT = 0.0F;
    private static final String DEFAULT_STRING = "";
    private static final boolean DEFAULT_BOOLEAN = false;
    private static final long DEFAULT_LONG = 0L;
    private static final Set<String> DEFAULT_STRING_SET = new HashSet(0);
    private static final Object DEFAULT_OBJECT = null;
    private static Context mContext = null;

    public static void bindApplication(@NonNull Context context) {
        mContext = context;
    }

    private HSSharedPreferencesUtil(String spName) {
        if (mContext != null) {
            this.mSharedPreferences = mContext.getSharedPreferences(spName, 0);
            if (this.mSharedPreferences != null) {
                this.mEditor = this.mSharedPreferences.edit();
            }
        }

    }

    public static synchronized HSSharedPreferencesUtil getInstance(String spName) {
        if (TextUtils.isEmpty(spName)) {
            throw new RuntimeException("please make sure you have valid file name");
        } else {
            HSSharedPreferencesUtil spUtil = (HSSharedPreferencesUtil)sharePreferBank.get(spName);
            if (spUtil == null) {
                spUtil = new HSSharedPreferencesUtil(spName);
                sharePreferBank.put(spName, spUtil);
            }

            return spUtil;
        }
    }

    public void putString(String key, String value) {
        if (!TextUtils.isEmpty(key) && !TextUtils.isEmpty(value) && this.mEditor != null) {
            this.mEditor.putString(key, value);
            this.mEditor.apply();
        }

    }

    public void putStringImmediately(String key, String value) {
        if (!TextUtils.isEmpty(key) && !TextUtils.isEmpty(value) && this.mEditor != null) {
            this.mEditor.putString(key, value);
            this.mEditor.commit();
        }

    }

    public String getString(String key) {
        String value = "";
        if (!TextUtils.isEmpty(key)) {
            value = this.getString(key, value);
        }

        return value;
    }

    public String getString(String key, String defaultValue) {
        String value = defaultValue;
        if (!TextUtils.isEmpty(key) && this.mSharedPreferences != null) {
            value = this.mSharedPreferences.getString(key, defaultValue);
        }

        return value;
    }

    public void putInt(String key, int value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putInt(key, value);
            this.mEditor.apply();
        }

    }

    public void putIntImmediately(String key, int value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putInt(key, value);
            this.mEditor.commit();
        }

    }

    public int getInt(String key) {
        int value = 0;
        if (!TextUtils.isEmpty(key)) {
            value = this.getInt(key, value);
        }

        return value;
    }

    public int getInt(String key, int defaultValue) {
        int value = defaultValue;
        if (!TextUtils.isEmpty(key) && this.mSharedPreferences != null) {
            value = this.mSharedPreferences.getInt(key, defaultValue);
        }

        return value;
    }

    public void putBoolean(String key, boolean value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putBoolean(key, value);
            this.mEditor.apply();
        }

    }

    public void putBooleanImmediately(String key, boolean value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putBoolean(key, value);
            this.mEditor.commit();
        }

    }

    public boolean getBoolean(String key) {
        boolean result = false;
        if (!TextUtils.isEmpty(key) && this.mSharedPreferences != null) {
            result = this.mSharedPreferences.getBoolean(key, result);
        }

        return result;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean result = defaultValue;
        if (!TextUtils.isEmpty(key) && this.mSharedPreferences != null) {
            result = this.mSharedPreferences.getBoolean(key, defaultValue);
        }

        return result;
    }

    public void putLong(String key, long value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putLong(key, value);
            this.mEditor.apply();
        }

    }

    public void putLongImmediately(String key, long value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putLong(key, value);
            this.mEditor.commit();
        }

    }

    public long getLong(String key) {
        long value = 0L;
        if (!TextUtils.isEmpty(key) && this.mSharedPreferences != null) {
            value = this.mSharedPreferences.getLong(key, value);
        }

        return value;
    }

    public long getLong(String key, long defaultValue) {
        long value = defaultValue;
        if (!TextUtils.isEmpty(key) && this.mSharedPreferences != null) {
            value = this.mSharedPreferences.getLong(key, defaultValue);
        }

        return value;
    }

    public void putFloat(String key, float value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putFloat(key, value);
            this.mEditor.apply();
        }

    }

    public void putFloatImmediately(String key, float value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putFloat(key, value);
            this.mEditor.commit();
        }

    }

    public float getFloat(String key) {
        float value = 0.0F;
        if (!TextUtils.isEmpty(key)) {
            value = this.getFloat(key, value);
        }

        return value;
    }

    public float getFloat(String key, float defaultValue) {
        float value = defaultValue;
        if (!TextUtils.isEmpty(key) && this.mSharedPreferences != null) {
            value = this.mSharedPreferences.getFloat(key, defaultValue);
        }

        return value;
    }

    public void putStringSet(String key, Set<String> value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putStringSet(key, value);
            this.mEditor.apply();
        }

    }

    public void putStringSetImmediately(String key, Set<String> value) {
        if (!TextUtils.isEmpty(key) && this.mEditor != null) {
            this.mEditor.putStringSet(key, value);
            this.mEditor.commit();
        }

    }

    public Set<String> getStringSet(String key) {
        Set<String> set = DEFAULT_STRING_SET;
        if (!TextUtils.isEmpty(key) && this.mSharedPreferences != null) {
            set = this.mSharedPreferences.getStringSet(key, (Set)null);
        }

        return set;
    }

    public Set<String> getStringSet(String key, Set<String> defaultValue) {
        Set<String> set = defaultValue;
        if (!TextUtils.isEmpty(key) && this.mSharedPreferences != null) {
            set = this.mSharedPreferences.getStringSet(key, defaultValue);
        }

        return set;
    }

    public void putObject(String key, Serializable object) {
        if (object != null && !TextUtils.isEmpty(key) && this.mEditor != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;

            try {
                oos = new ObjectOutputStream(bos);
                oos.writeObject(object);
                oos.writeObject((Object)null);
                String bytesToBaseString = new String(Base64.encode(bos.toByteArray(), 0), "UTF-8");
                this.mEditor.putString(key, bytesToBaseString);
                this.mEditor.apply();
            } catch (IOException var14) {
                var14.printStackTrace();
            } finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }

                    if (oos != null) {
                        oos.close();
                    }
                } catch (IOException var13) {
                    var13.printStackTrace();
                }

            }
        }

    }

    public void putObjectImmediately(String key, Serializable object) {
        if (object != null && !TextUtils.isEmpty(key) && this.mEditor != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;

            try {
                oos = new ObjectOutputStream(bos);
                oos.writeObject(object);
                oos.writeObject((Object)null);
                String bytesToBaseString = new String(Base64.encode(bos.toByteArray(), 0), "UTF-8");
                this.mEditor.putString(key, bytesToBaseString);
                this.mEditor.commit();
            } catch (IOException var14) {
                var14.printStackTrace();
            } finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }

                    if (oos != null) {
                        oos.close();
                    }
                } catch (IOException var13) {
                    var13.printStackTrace();
                }

            }
        }

    }

    public Object getObject(String key) {
        Object value = DEFAULT_OBJECT;
        return !TextUtils.isEmpty(key) ? this.getObject(key, value) : value;
    }

    public Object getObject(String key, Object defaultValue) {
        Object value = defaultValue;
        if (!TextUtils.isEmpty(key)) {
            String bytesToBaseString = this.getString(key, "");
            ByteArrayInputStream bais = null;
            ObjectInputStream localObjectInputStream = null;

            Object var7;
            try {
                bais = new ByteArrayInputStream(Base64.decode(bytesToBaseString.getBytes("UTF-8"), 0));
                localObjectInputStream = new ObjectInputStream(bais);
                value = localObjectInputStream.readObject();
                localObjectInputStream.close();
                bais.close();
                if (value == null) {
                    return value;
                }

                var7 = value;
            } catch (Exception var18) {
                var18.printStackTrace();
                return value;
            } finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }

                    if (localObjectInputStream != null) {
                        localObjectInputStream.close();
                    }
                } catch (IOException var17) {
                    var17.printStackTrace();
                }

            }

            return var7;
        } else {
            return value;
        }
    }

    public boolean contains(String key) {
        return this.mSharedPreferences != null ? this.mSharedPreferences.contains(key) : false;
    }

    public void remove(String key) {
        if (this.mEditor != null) {
            this.mEditor.remove(key);
            this.mEditor.apply();
        }

    }

    public void removeImmediately(String key) {
        if (this.mEditor != null) {
            this.mEditor.remove(key);
            this.mEditor.commit();
        }

    }

    public void clear() {
        if (this.mEditor != null) {
            this.mEditor.clear();
            this.mEditor.apply();
        }

    }

    public void clearImmediately() {
        if (this.mEditor != null) {
            this.mEditor.clear();
            this.mEditor.commit();
        }

    }

    public Map<String, ?> getAll() {
        return this.mSharedPreferences != null ? this.mSharedPreferences.getAll() : null;
    }
}

