package com.cloud.sdk.commonutil.util;

import static android.widget.Toast.LENGTH_SHORT;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import java.lang.reflect.Field;

@SuppressLint("SoonBlockedPrivateApi")
public class HSToastUtil {
    private static Handler mHandler = new Handler(Looper.getMainLooper());
    private static Toast toast = null;
    private static Field sField_TN;
    private static Field sField_TN_Handler;

    public HSToastUtil() {
    }

    public static void showToast(final int resId) {
        final Context context = HSCoreUtil.getContext();
        if (resId > 0) {
            mHandler.post(new Runnable() {
                public void run() {
                    if (HSToastUtil.toast != null) {
                        HSToastUtil.toast.setText(resId);
                        HSToastUtil.toast.setDuration(LENGTH_SHORT);
                        HSToastUtil.hook(HSToastUtil.toast);
                    } else {
                        HSToastUtil.toast = Toast.makeText(context.getApplicationContext(), resId, LENGTH_SHORT);
                    }

                    HSToastUtil.toast.show();
                }
            });
        }
    }

    public static void showToast(final String text) {
        final Context context = HSCoreUtil.getContext();
        if (!TextUtils.isEmpty(text)) {
            mHandler.post(new Runnable() {
                public void run() {
                    if (HSToastUtil.toast != null) {
                        HSToastUtil.toast.setText(text);
                        HSToastUtil.toast.setDuration(LENGTH_SHORT);
                        HSToastUtil.hook(HSToastUtil.toast);
                    } else {
                        HSToastUtil.toast = Toast.makeText(context.getApplicationContext(), text, LENGTH_SHORT);
                    }

                    HSToastUtil.toast.show();
                }
            });
        }
    }

    public static void showLongToast(final int resId) {
        final Context context = HSCoreUtil.getContext();
        if (resId > 0) {
            mHandler.post(new Runnable() {
                public void run() {
                    if (HSToastUtil.toast != null) {
                        HSToastUtil.toast.setText(resId);
                        HSToastUtil.toast.setDuration(Toast.LENGTH_LONG);
                        HSToastUtil.hook(HSToastUtil.toast);
                    } else {
                        HSToastUtil.toast = Toast.makeText(context.getApplicationContext(), resId, Toast.LENGTH_LONG);
                    }

                    HSToastUtil.toast.show();
                }
            });
        }
    }

    public static void showLongToast(final String text) {
        final Context context = HSCoreUtil.getContext();
        if (!TextUtils.isEmpty(text)) {
            mHandler.post(new Runnable() {
                public void run() {
                    if (HSToastUtil.toast != null) {
                        HSToastUtil.toast.setText(text);
                        HSToastUtil.toast.setDuration(Toast.LENGTH_LONG);
                        HSToastUtil.hook(HSToastUtil.toast);
                    } else {
                        HSToastUtil.toast = Toast.makeText(context.getApplicationContext(), text, Toast.LENGTH_LONG);
                    }

                    HSToastUtil.toast.show();
                }
            });
        }
    }

    private static void hook(Toast toast) {
        try {
            Object tn = sField_TN.get(toast);
            Handler preHandler = (Handler)sField_TN_Handler.get(tn);
            if (preHandler != null && !(preHandler instanceof HSToastUtil.SafelyHandlerWrapper)) {
                sField_TN_Handler.set(tn, new HSToastUtil.SafelyHandlerWrapper(preHandler));
            }
        } catch (Exception var3) {
            var3.printStackTrace();
        }

    }

    static {
        try {
            sField_TN = Toast.class.getDeclaredField("mTN");
            sField_TN.setAccessible(true);
            sField_TN_Handler = sField_TN.getType().getDeclaredField("mHandler");
            sField_TN_Handler.setAccessible(true);
        } catch (Exception var1) {
            var1.printStackTrace();
        }

    }

    private static class SafelyHandlerWrapper extends Handler {
        private Handler impl;

        SafelyHandlerWrapper(Handler impl) {
            this.impl = impl;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            } catch (Exception var3) {
                var3.printStackTrace();
            }

        }

        public void handleMessage(Message msg) {
            this.impl.handleMessage(msg);
        }
    }
}

