package com.cloud.sdk.commonutil.util

import android.graphics.drawable.BitmapDrawable
import android.widget.ImageView
import com.cloud.sdk.commonutil.util.imagerender.GlideRender


object HisavanaImageLoader {
    private const val TAG = "HisavanaImageLoader"

    @JvmStatic
    fun destroyImageView(imageView: ImageView?) {
        try {
            if (imageView != null && imageView.drawable != null && !GlideRender.isGlideDependency) {
                if (imageView.drawable is BitmapDrawable) {
                    val drawable = imageView.drawable as? BitmapDrawable
                    if (drawable != null) {
                        val bitmap = drawable.bitmap
                        if (bitmap != null && !bitmap.isRecycled) {
                            bitmap.recycle()
                        }
                    }
                } else {
                    imageView.setImageDrawable(null)
                }
            }
        } catch (e: Throwable) {
            CommonLogUtil.Log().w(TAG, "destroyImageView error msg = ${e.message}")
        }
    }
}
