/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.athena;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.hardware.Camera;
import android.hardware.camera2.CameraManager;
import android.location.LocationManager;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.accessibility.AccessibilityManager;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.cloud.sdk.commonutil.athena.PostConstant;
import com.cloud.sdk.commonutil.athena.SensorUtil;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.AESUtils;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class AntiFraudUtil {
    private static final String TAG = "anti_fraud_log";
    public static final boolean IS_TEST = false;
    private static final boolean IS_LOGCAT_TAG = Log.isLoggable((String)"anti_fraud_log", (int)3);
    private static Intent batteryBroadcast = null;
    private static BroadcastReceiver batteryBroadcastReceiver = null;
    private static final int IS_CHARGE_FALSE = 0;
    private static final int IS_CHARGE_TRUE = 1;
    private static final int IS_CHARGE_UNKNOWN = 2;
    private static final int IS_SIM_CARD_FALSE = 0;
    private static final int IS_SIM_CARD_TRUE = 4;
    private static final int IS_SIM_CARD_UNKNOWN = 8;
    private static int isSimCardValue = -1;
    private static final int IS_CAMERAS_FALSE = 0;
    private static final int IS_CAMERAS_TRUE = 16;
    private static final int IS_CAMERAS_UNKNOWN = 32;
    private static int isCamerasValue = -1;
    private static final int IS_ROOT_FALSE = 0;
    private static final int IS_ROOT_TRUE = 64;
    private static int isRootValue = -1;
    private static final String[] ROOT_RELATED_DIRS = new String[]{"/su", "/su/bin/su", "/sbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/data/local/su", "/system/xbin/su", "/system/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/system/bin/cufsdosck", "/system/xbin/cufsdosck", "/system/bin/cufsmgr", "/system/xbin/cufsmgr", "/system/bin/cufaevdd", "/system/xbin/cufaevdd", "/system/bin/conbb", "/system/xbin/conbb"};
    private static final int IS_CHANGE_FRAME_FALSE = 0;
    private static final int IS_CHANGE_FRAME_TRUE = 128;
    private static final int IS_ADB_ENABLE_FALSE = 0;
    private static final int IS_ADB_ENABLE_TRUE = 256;
    private static int isAdbEnableValue = -1;
    private static final String SCREEN_READER_INTENT_ACTION = "android.accessibilityservice.AccessibilityService";
    private static final String SCREEN_READER_INTENT_CATEGORY = "android.accessibilityservice.category.FEEDBACK_SPOKEN";
    private static final int IS_ACCESSIBILITY_FALSE = 0;
    private static final int IS_ACCESSIBILITY_TRUE = 512;
    private static int isAccessibilityValue = -1;
    private static final int IS_HOOK_FALSE = 0;
    private static final int IS_HOOK_TRUE = 1024;
    private static int isHookValue = -1;
    private static final int IS_OPEN_SYS_FALSE = 0;
    private static final int IS_OPEN_SYS_TRUE = 2048;
    private static final int IS_OPEN_APP_FALSE = 0;
    private static final int IS_OPEN_APP_TRUE = 4096;
    private static int isOpenAppValue = -1;
    private static final String[] PACKAGE_NAME = new String[]{"com.bly.dkplat", "com.by.chaos", "com.lbe.parallel", "com.excelliance.dualaid", "com.lody.virtual", "com.qihoo.magic", "com.dual.dualgenius", "com.jiubang.commerce.gomultiple"};
    private static final int IS_EMULATOR_FALSE = 0;
    private static final int IS_EMULATOR_TRUE = 8192;
    private static int isEmulatorValue = -1;
    private static final String[] KNOWN_PIPES = new String[]{"/dev/socket/qemud", "/dev/qemu_pipe"};
    private static final String[] KNOWN_QEMU_DRIVERS = new String[]{"goldfish"};
    private static final String[] KNOWN_FILES = new String[]{"/system/lib/libc_malloc_debug_qemu.so", "/sys/qemu_trace", "/system/bin/qemu-props"};
    private static final int IS_USE_VPN_FALSE = 0;
    private static final int IS_USE_VPN_TRUE = 16384;
    private static int isUseVpnValue = -1;
    private static final int IS_USE_PROXY_FALSE = 0;
    private static final int IS_USE_PROXY_TRUE = 32768;
    private static int isUseProxyValue = -1;
    private static final int IS_MOCK_LOCATION_FALSE = 0;
    private static final int IS_MOCK_LOCATION_TRUE = 65536;
    private static int isMockLocationValue = -1;
    private static final int IS_MONKEY_FALSE = 0;
    private static final int IS_MONKEY_TRUE = 131072;
    private static boolean isMonkey = false;
    private static int supportAppLinkFlag = -1;
    private static final int MAX_PARAMS = 65535;
    private static String currentBtName = "bluetooth_name";
    private static String baseBandVersion = "base_band_version";
    private static String bootTime = "boot_time";
    private static String phoneName = "phone_name";
    private static String ssid = "ssid";
    private static boolean isWifiListLoaded = false;
    private static String[] wifiListValue = new String[0];
    private static String screenBrightness = "screen_brightness";
    private static String batteryPercent = "battery_percent";
    private static String chargeType = "charge_type";
    private static String romName = "rom_name";
    private static String romBuildTime = "rom_build_time";
    private static String osApi = "os_api";
    private static String buildId = "build_id";
    private static String cpuCores = "cpu_cores";
    private static final String K_CPU_INFO_CUR_FREQ_FILEPATH = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq";
    private static String cpuCoresCnt = "cpu_cores_cnt";
    private static String cpuAbi = "cpu_abi";
    private static String cpuKernel = "cpu_kernel";
    private static String board = "board";
    private static String hardWare = "hard_ware";
    private static String fingerPrint = "finger_print";
    private static int numberOfCameras = 0;
    private static boolean isNumberOfCamerasLoaded = false;
    private static String phoneHeight = "phone_height";
    private static int totalMemory = 0;
    private static boolean isTotalMemoryLoaded = false;
    private static int totalDiskSize = 0;
    private static int availableDiskSize = 0;
    private static boolean isTotalDiskSizeLoaded = false;
    private static final String TAG_KEY = "\u0001";
    private static final String TAG_VALUE = "\u0002";
    private static final AtomicBoolean IS_PRELOAD_LOADING = new AtomicBoolean(true);
    private static final Bundle ANTI_FRAUD_FULL_BUNDLE = new Bundle();
    private static String antiFraudFullString;
    private static String antiFraudLiteString;
    private static final String ANTI_FRAUD_SP_NAME = "anti_fraud_sp_name";
    private static final String IS_OPEN_ANTI_FRAUD_SP_KEY = "is_open_anti_fraud_sp_key";
    private static final String ANTI_FRAUD_SUB_FUNCTION_SP_KEY = "anti_fraud_sub_function_sp_key";
    private static volatile Boolean isOpenAntiFraudCache;
    private static volatile String antiFraudSubfunctionControl;

    private AntiFraudUtil() {
    }

    public static void log(String msg) {
        if (IS_LOGCAT_TAG) {
            Log.w((String)TAG, (String)msg);
        }
    }

    private static int isCharge() {
        try {
            if (!AntiFraudUtil.isTwoBitOpen(0)) {
                return 2;
            }
            AntiFraudUtil.initBatteryBroadcast();
            if (batteryBroadcast != null) {
                int status = batteryBroadcast.getIntExtra("status", -1);
                AntiFraudUtil.destroyBatteryBroadcast();
                if (status == 2) {
                    return 1;
                }
                if (status == 1) {
                    return 2;
                }
                return 0;
            }
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        AntiFraudUtil.destroyBatteryBroadcast();
        return 2;
    }

    @SuppressLint(value={"MissingPermission"})
    private static int isSimCard() {
        try {
            if (!AntiFraudUtil.isTwoBitOpen(2)) {
                return 8;
            }
            if (isSimCardValue != -1) {
                return isSimCardValue;
            }
            if (ContextCompat.checkSelfPermission((Context)HSCoreUtil.getContext(), (String)"android.permission.READ_PHONE_STATE") != 0) {
                return 8;
            }
            isSimCardValue = 8;
            String imsi = "";
            TelephonyManager manager = (TelephonyManager)HSCoreUtil.getContext().getSystemService("phone");
            if (null != manager) {
                imsi = manager.getSubscriberId();
            }
            isSimCardValue = imsi == null || imsi.length() <= 0 ? 0 : 4;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isSimCardValue;
    }

    private static int isCameras() {
        try {
            if (!AntiFraudUtil.isTwoBitOpen(4)) {
                return 32;
            }
            if (isCamerasValue != -1) {
                return isCamerasValue;
            }
            isCamerasValue = 32;
            boolean hasCamera = false;
            PackageManager pm = HSCoreUtil.getContext().getPackageManager();
            if (null != pm) {
                hasCamera = pm.hasSystemFeature("android.hardware.camera.any");
            }
            isCamerasValue = hasCamera ? 16 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isCamerasValue;
    }

    private static int isRoot() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(6)) {
                return 0;
            }
            if (isRootValue != -1) {
                return isRootValue;
            }
            isRootValue = 0;
            boolean hasRootDir = false;
            for (String dir : ROOT_RELATED_DIRS) {
                if (!new File(dir).exists()) continue;
                hasRootDir = true;
                break;
            }
            boolean isRoot = Build.TAGS != null && Build.TAGS.contains("test-keys") || hasRootDir;
            isRootValue = isRoot ? 64 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isRootValue;
    }

    private static int isChangeFrame() {
        if (!AntiFraudUtil.isOneBitOpen(7)) {
            return 0;
        }
        return 0;
    }

    private static int isAdbEnable() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(8)) {
                return 0;
            }
            if (isAdbEnableValue != -1) {
                return isAdbEnableValue;
            }
            isAdbEnableValue = 0;
            boolean isOpenDevelopmentSetting = Settings.Secure.getInt((ContentResolver)HSCoreUtil.getContext().getContentResolver(), (String)"development_settings_enabled", (int)0) != 0;
            boolean isUsbDebugSetting = Settings.Secure.getInt((ContentResolver)HSCoreUtil.getContext().getContentResolver(), (String)"adb_enabled", (int)0) != 0;
            boolean isAdbEnable = isOpenDevelopmentSetting || isUsbDebugSetting;
            isAdbEnableValue = isAdbEnable ? 256 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isAdbEnableValue;
    }

    private static boolean isScreenReaderActive() {
        Intent screenReaderIntent = new Intent(SCREEN_READER_INTENT_ACTION);
        screenReaderIntent.addCategory(SCREEN_READER_INTENT_CATEGORY);
        List screenReaders = HSCoreUtil.getContext().getPackageManager().queryIntentServices(screenReaderIntent, 0);
        if (screenReaders.isEmpty()) {
            return false;
        }
        boolean hasActiveScreenReader = false;
        if (Build.VERSION.SDK_INT >= 26) {
            for (ResolveInfo screenReader : screenReaders) {
                hasActiveScreenReader |= AntiFraudUtil.isAccessibilitySettingsOn(HSCoreUtil.getContext(), screenReader.serviceInfo.packageName + "/" + screenReader.serviceInfo.name);
            }
        } else {
            ArrayList<String> runningServices = new ArrayList<String>();
            ActivityManager manager = (ActivityManager)HSCoreUtil.getContext().getSystemService("activity");
            for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
                runningServices.add(service.service.getPackageName());
            }
            for (ResolveInfo screenReader : screenReaders) {
                if (!runningServices.contains(screenReader.serviceInfo.packageName)) continue;
                hasActiveScreenReader = true;
                break;
            }
        }
        return hasActiveScreenReader;
    }

    private static boolean isAccessibilitySettingsOn(Context context, String service) {
        TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
        String settingValue = Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"enabled_accessibility_services");
        if (settingValue != null) {
            mStringColonSplitter.setString(settingValue);
            while (mStringColonSplitter.hasNext()) {
                String accessibilityService = mStringColonSplitter.next();
                if (!accessibilityService.equalsIgnoreCase(service)) continue;
                return true;
            }
        }
        return false;
    }

    private static int isAccessibility() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(9)) {
                return 0;
            }
            if (isAccessibilityValue != -1) {
                return isAccessibilityValue;
            }
            isAccessibilityValue = 0;
            AccessibilityManager am = (AccessibilityManager)HSCoreUtil.getContext().getSystemService("accessibility");
            boolean isAccessibilityEnabledFlag = am.isEnabled();
            boolean isExploreByTouchEnabledFlag = AntiFraudUtil.isScreenReaderActive();
            boolean isAccessibilityEnabled = isAccessibilityEnabledFlag && isExploreByTouchEnabledFlag;
            isAccessibilityValue = isAccessibilityEnabled ? 512 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isAccessibilityValue;
    }

    private static boolean findHookAppName() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean findHookAppFile() {
        HashSet<String> libraries = new HashSet<String>();
        String mapsFilename = "/proc/" + Process.myPid() + "/maps";
        try (FileReader fileReader = new FileReader(mapsFilename);
             BufferedReader reader = new BufferedReader(fileReader);){
            String library;
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.endsWith(".so") && !line.endsWith(".jar")) continue;
                int n = line.lastIndexOf(" ");
                libraries.add(line.substring(n + 1));
            }
            Iterator iterator = libraries.iterator();
            do {
                if (!iterator.hasNext()) return false;
                library = (String)iterator.next();
                if (!library.contains("com.saurik.substrate")) continue;
                boolean bl = true;
                return bl;
            } while (!library.contains("XposedBridge.jar"));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return false;
    }

    private static boolean findHookStack() {
        try {
            throw new AndroidRuntimeException("findhook");
        }
        catch (Exception e) {
            return AntiFraudUtil.extracted(e);
        }
    }

    private static boolean extracted(Exception e) {
        int zygoteInitCallCount = 0;
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            if ("com.android.internal.os.ZygoteInit".equals(stackTraceElement.getClassName())) {
                if (++zygoteInitCallCount != 2) continue;
                return true;
            }
            if ("com.saurik.substrate.MS$2".equals(stackTraceElement.getClassName()) && "invoked".equals(stackTraceElement.getMethodName())) {
                return true;
            }
            if ("de.robv.android.xposed.XposedBridge".equals(stackTraceElement.getClassName()) && "main".equals(stackTraceElement.getMethodName())) {
                return true;
            }
            if (!"de.robv.android.xposed.XposedBridge".equals(stackTraceElement.getClassName()) || !"handleHookedMethod".equals(stackTraceElement.getMethodName())) continue;
            return true;
        }
        return false;
    }

    private static int isHook() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(10)) {
                return 0;
            }
            if (isHookValue != -1) {
                return isHookValue;
            }
            isHookValue = 0;
            boolean isHook = AntiFraudUtil.findHookAppName() || AntiFraudUtil.findHookAppFile() || AntiFraudUtil.findHookStack();
            isHookValue = isHook ? 1024 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isHookValue;
    }

    private static int isOpenSys() {
        if (!AntiFraudUtil.isOneBitOpen(11)) {
            return 0;
        }
        return 0;
    }

    private static int isOpenApp() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(12)) {
                return 0;
            }
            if (isOpenAppValue != -1) {
                return isOpenAppValue;
            }
            isOpenAppValue = 0;
            boolean isOpenApp = false;
            String path = HSCoreUtil.getContext().getFilesDir().getPath();
            for (String vtpkg : PACKAGE_NAME) {
                if (!path.contains(vtpkg)) continue;
                isOpenApp = true;
                break;
            }
            isOpenAppValue = isOpenApp ? 4096 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isOpenAppValue;
    }

    private static boolean checkPipes() {
        for (String pipes : KNOWN_PIPES) {
            File qemuSocket = new File(pipes);
            if (!qemuSocket.exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkQemuDriverFile() {
        File driverFile = new File("/proc/tty/drivers");
        if (!driverFile.exists()) return false;
        if (!driverFile.canRead()) return false;
        byte[] data = new byte[1024];
        try (FileInputStream inStream = new FileInputStream(driverFile);){
            int size = ((InputStream)inStream).read(data);
            if (size <= 0) return false;
            String driverData = new String(data);
            String[] stringArray = KNOWN_QEMU_DRIVERS;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String knownQemuDriver = stringArray[n2];
                if (driverData.contains(knownQemuDriver)) {
                    boolean bl = true;
                    return bl;
                }
                ++n2;
            }
            return false;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return false;
    }

    private static boolean checkEmulatorFiles() {
        for (String fileName : KNOWN_FILES) {
            File qemuFile = new File(fileName);
            if (!qemuFile.exists()) continue;
            return true;
        }
        return false;
    }

    private static boolean checkEmulatorBuild() {
        return "android".equalsIgnoreCase(Build.BRAND) || Build.MODEL.toLowerCase().contains("sdk");
    }

    private static int isEmulator() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(13)) {
                return 0;
            }
            if (isEmulatorValue != -1) {
                return isEmulatorValue;
            }
            isEmulatorValue = 0;
            boolean isEmulator = AntiFraudUtil.checkEmulatorBuild() || AntiFraudUtil.checkEmulatorFiles() || AntiFraudUtil.checkQemuDriverFile() || AntiFraudUtil.checkPipes();
            isEmulatorValue = isEmulator ? 8192 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isEmulatorValue;
    }

    private static int isUseVpn() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(14)) {
                return 0;
            }
            if (isUseVpnValue != -1) {
                return isUseVpnValue;
            }
            isUseVpnValue = 0;
            boolean isUseVpn = false;
            Enumeration<NetworkInterface> niList = NetworkInterface.getNetworkInterfaces();
            if (niList != null) {
                for (NetworkInterface intf : Collections.list(niList)) {
                    if (!intf.isUp() || intf.getInterfaceAddresses().isEmpty()) {
                        AntiFraudUtil.log("The network is disconnected.");
                        continue;
                    }
                    if (!"tun0".equals(intf.getName()) && !"ppp0".equals(intf.getName())) continue;
                    isUseVpn = true;
                    break;
                }
            }
            isUseVpnValue = isUseVpn ? 16384 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isUseVpnValue;
    }

    private static int isUseProxy() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(15)) {
                return 0;
            }
            if (isUseProxyValue != -1) {
                return isUseProxyValue;
            }
            isUseProxyValue = 0;
            String proxyAddress = System.getProperty("http.proxyHost");
            String portStr = System.getProperty("http.proxyPort");
            int proxyPort = Integer.parseInt(portStr != null ? portStr : "-1");
            boolean isUseProxy = !TextUtils.isEmpty((CharSequence)proxyAddress) && proxyPort != -1;
            isUseProxyValue = isUseProxy ? 32768 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isUseProxyValue;
    }

    private static int isMockLocation() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(16)) {
                return 0;
            }
            if (isMockLocationValue != -1) {
                return isMockLocationValue;
            }
            isMockLocationValue = 0;
            boolean isMockLocation = false;
            if (Build.VERSION.SDK_INT >= 23) {
                if (ContextCompat.checkSelfPermission((Context)HSCoreUtil.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ContextCompat.checkSelfPermission((Context)HSCoreUtil.getContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                    AntiFraudUtil.log("No location permission is currently available");
                } else {
                    LocationManager locationManager = (LocationManager)HSCoreUtil.getContext().getSystemService("location");
                    String providerStr = "gps";
                    locationManager.setTestProviderEnabled(providerStr, true);
                    isMockLocation = true;
                }
            } else {
                isMockLocation = Settings.Secure.getInt((ContentResolver)HSCoreUtil.getContext().getContentResolver(), (String)"mock_location", (int)0) != 0;
            }
            isMockLocationValue = isMockLocation ? 65536 : 0;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return isMockLocationValue;
    }

    private static int isMonkey() {
        if (!AntiFraudUtil.isOneBitOpen(17)) {
            return 0;
        }
        return isMonkey ? 131072 : 0;
    }

    public static void setMonkey(boolean monkey) {
        isMonkey = monkey;
    }

    public static boolean isSupportAppLink() {
        if (supportAppLinkFlag >= 0) {
            return supportAppLinkFlag == 1;
        }
        String antiFraudSub = AntiFraudUtil.getAntiFraudSubfunctionControl();
        supportAppLinkFlag = TextUtils.equals((CharSequence)antiFraudSub, (CharSequence)"0") ? 1 : (AntiFraudUtil.isOneBitOpen(27) ? 1 : 0);
        return supportAppLinkFlag == 1;
    }

    public static int encryptInt(int numA, int numB) {
        if (numA > 65535 || numB > 65535) {
            return -1;
        }
        int numC = numA << 16;
        return numC ^ numB;
    }

    private static String subString(String tag) {
        if (null != tag && tag.length() > 100) {
            tag = tag.substring(0, 100);
        }
        return tag;
    }

    private static int addState(int verify, int type) {
        return verify | type;
    }

    private static int getCpInt() {
        int currentState = 0;
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isCharge());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isSimCard());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isCameras());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isRoot());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isChangeFrame());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isAdbEnable());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isAccessibility());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isHook());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isOpenSys());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isOpenApp());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isEmulator());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isUseVpn());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isUseProxy());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isMockLocation());
        currentState = AntiFraudUtil.addState(currentState, AntiFraudUtil.isMonkey());
        return currentState;
    }

    @SuppressLint(value={"MissingPermission"})
    private static String getCurrentBtName() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(18)) {
                return "bluetooth_name";
            }
            if (!"bluetooth_name".equals(currentBtName)) {
                return currentBtName;
            }
            if (Build.VERSION.SDK_INT > 30 && ActivityCompat.checkSelfPermission((Context)HSCoreUtil.getContext().getApplicationContext(), (String)"android.permission.BLUETOOTH_CONNECT") != 0) {
                return currentBtName;
            }
            BluetoothManager bluetoothManager = (BluetoothManager)HSCoreUtil.getContext().getSystemService("bluetooth");
            BluetoothAdapter adapter = bluetoothManager.getAdapter();
            currentBtName = null != adapter ? AntiFraudUtil.subString(adapter.getName()) : "";
        }
        catch (Exception e) {
            currentBtName = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return currentBtName;
    }

    private static String getBaseBandVersion() {
        if (!"base_band_version".equals(baseBandVersion)) {
            return baseBandVersion;
        }
        try {
            baseBandVersion = AntiFraudUtil.subString(Build.VERSION.INCREMENTAL);
        }
        catch (Exception e) {
            baseBandVersion = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return baseBandVersion;
    }

    private static String getBootTime() {
        if (!"boot_time".equals(bootTime)) {
            return bootTime;
        }
        try {
            int time = (int)((System.currentTimeMillis() - SystemClock.elapsedRealtime()) / 1000L);
            bootTime = Integer.toHexString(time);
        }
        catch (Exception e) {
            bootTime = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return bootTime;
    }

    private static String getPhoneName() {
        if (!"phone_name".equals(phoneName)) {
            return phoneName;
        }
        try {
            phoneName = AntiFraudUtil.subString(Build.DEVICE);
        }
        catch (Exception e) {
            phoneName = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return phoneName;
    }

    private static String getSsid() {
        if (!"ssid".equals(ssid)) {
            return ssid;
        }
        try {
            WifiManager wifiManager = (WifiManager)HSCoreUtil.getContext().getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            ssid = null != wifiInfo ? AntiFraudUtil.subString(wifiInfo.getSSID()) : "";
        }
        catch (Exception e) {
            ssid = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return ssid;
    }

    private static String[] getWifiList() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(19)) {
                return new String[0];
            }
            if (isWifiListLoaded) {
                return wifiListValue;
            }
            isWifiListLoaded = true;
            if (ActivityCompat.checkSelfPermission((Context)HSCoreUtil.getContext().getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") != 0 || ActivityCompat.checkSelfPermission((Context)HSCoreUtil.getContext().getApplicationContext(), (String)"android.permission.ACCESS_WIFI_STATE") != 0) {
                return wifiListValue;
            }
            WifiManager wifiManager = (WifiManager)HSCoreUtil.getContext().getApplicationContext().getSystemService("wifi");
            List scanWifiList = wifiManager.getScanResults();
            ArrayList<String> wifiList = new ArrayList<String>();
            if (scanWifiList != null && !scanWifiList.isEmpty()) {
                for (int i = 0; i < scanWifiList.size(); ++i) {
                    ScanResult scanResult = (ScanResult)scanWifiList.get(i);
                    if (wifiList.size() > 4) break;
                    if (scanResult.SSID.isEmpty()) continue;
                    wifiList.add(AntiFraudUtil.subString(scanResult.SSID));
                }
            }
            wifiListValue = wifiList.toArray(new String[0]);
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return wifiListValue;
    }

    private static String getScreenBrightnessCapacity() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(20)) {
                return "screen_brightness";
            }
            if (!"screen_brightness".equals(screenBrightness)) {
                return screenBrightness;
            }
            int systemBrightness = Settings.System.getInt((ContentResolver)HSCoreUtil.getContext().getContentResolver(), (String)"screen_brightness");
            int i = AntiFraudUtil.encryptInt(systemBrightness, 255);
            screenBrightness = Integer.toHexString(i);
        }
        catch (Exception e) {
            screenBrightness = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return screenBrightness;
    }

    private static int getBatteryTotal() {
        return 0;
    }

    private static int getBatteryCurrent() {
        int capacity = 0;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                BatteryManager manager = (BatteryManager)HSCoreUtil.getContext().getSystemService("batterymanager");
                capacity = manager.getIntProperty(4);
            } else {
                AntiFraudUtil.initBatteryBroadcast();
                if (batteryBroadcast != null) {
                    capacity = batteryBroadcast.getIntExtra("level", -1);
                }
            }
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return capacity;
    }

    private static String getBatteryPercent() {
        if (!"battery_percent".equals(batteryPercent)) {
            return batteryPercent;
        }
        try {
            int i = AntiFraudUtil.encryptInt(AntiFraudUtil.getBatteryCurrent(), AntiFraudUtil.getBatteryTotal());
            batteryPercent = Integer.toHexString(i);
        }
        catch (Exception e) {
            batteryPercent = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return batteryPercent;
    }

    private static String getChargeType() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(21)) {
                return "charge_type";
            }
            if (!"charge_type".equals(chargeType)) {
                return chargeType;
            }
            AntiFraudUtil.initBatteryBroadcast();
            if (batteryBroadcast != null) {
                int chargePlug = batteryBroadcast.getIntExtra("plugged", -1);
                chargeType = chargePlug == 1 ? "1" : (chargePlug == 2 ? "2" : (chargePlug == 4 ? "3" : "0"));
            }
        }
        catch (Exception e) {
            chargeType = "0";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return chargeType;
    }

    private static String getRomName() {
        if (!"rom_name".equals(romName)) {
            return romName;
        }
        try {
            romName = AntiFraudUtil.subString(Build.MANUFACTURER);
        }
        catch (Exception e) {
            romName = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return romName;
    }

    private static String getRomVersion() {
        return "";
    }

    private static String getRomBuildTime() {
        if (!"rom_build_time".equals(romBuildTime)) {
            return romBuildTime;
        }
        try {
            return Long.toHexString(Build.TIME);
        }
        catch (Exception e) {
            romBuildTime = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
            return romBuildTime;
        }
    }

    private static String getOsApi() {
        if (!"os_api".equals(osApi)) {
            return osApi;
        }
        try {
            osApi = Integer.toHexString(Build.VERSION.SDK_INT);
        }
        catch (Exception e) {
            osApi = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return osApi;
    }

    private static String getBuildId() {
        if (!"build_id".equals(buildId)) {
            return buildId;
        }
        try {
            buildId = AntiFraudUtil.subString(Build.ID);
        }
        catch (Exception e) {
            buildId = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return buildId;
    }

    private static String getCpuCores() {
        if (!"cpu_cores".equals(cpuCores)) {
            return cpuCores;
        }
        try {
            cpuCores = AntiFraudUtil.subString(Build.CPU_ABI);
        }
        catch (Exception e) {
            cpuCores = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return cpuCores;
    }

    private static int getCurCpuFreq() {
        int result = 0;
        try (FileReader fr = new FileReader(K_CPU_INFO_CUR_FREQ_FILEPATH);
             BufferedReader br = new BufferedReader(fr);){
            String text = br.readLine();
            result = Integer.parseInt(text.trim());
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return result;
    }

    private static String getCpuCoresCnt() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(22)) {
                return "cpu_cores_cnt";
            }
            if (!"cpu_cores_cnt".equals(cpuCoresCnt)) {
                return cpuCoresCnt;
            }
            int ccf = Runtime.getRuntime().availableProcessors();
            int curCpuFreq = AntiFraudUtil.getCurCpuFreq() / 1000;
            int i = AntiFraudUtil.encryptInt(ccf, curCpuFreq);
            cpuCoresCnt = Integer.toHexString(i);
        }
        catch (Exception e) {
            cpuCoresCnt = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return cpuCoresCnt;
    }

    private static String getCpuAbi() {
        if (!"cpu_abi".equals(cpuAbi)) {
            return cpuAbi;
        }
        try {
            cpuAbi = AntiFraudUtil.subString(Build.CPU_ABI);
        }
        catch (Exception e) {
            cpuAbi = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return cpuAbi;
    }

    private static String getCpuKernel() {
        if (!"cpu_kernel".equals(cpuKernel)) {
            return cpuKernel;
        }
        try {
            cpuKernel = AntiFraudUtil.subString(Build.CPU_ABI2);
        }
        catch (Exception e) {
            cpuKernel = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return cpuKernel;
    }

    private static String getBoard() {
        if (!"board".equals(board)) {
            return board;
        }
        try {
            board = AntiFraudUtil.subString(Build.BOARD);
        }
        catch (Exception e) {
            board = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return board;
    }

    private static String getHardWare() {
        if (!"hard_ware".equals(hardWare)) {
            return hardWare;
        }
        try {
            hardWare = AntiFraudUtil.subString(Build.HARDWARE);
        }
        catch (Exception e) {
            hardWare = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return hardWare;
    }

    private static String getFingerPrint() {
        if (!"finger_print".equals(fingerPrint)) {
            return fingerPrint;
        }
        try {
            fingerPrint = AntiFraudUtil.subString(Build.FINGERPRINT);
        }
        catch (Exception e) {
            fingerPrint = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return fingerPrint;
    }

    private static String getNumberOfCameras() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(23)) {
                return Integer.toHexString(0);
            }
            if (isNumberOfCamerasLoaded) {
                return Integer.toHexString(numberOfCameras);
            }
            isNumberOfCamerasLoaded = true;
            if (Build.VERSION.SDK_INT >= 21) {
                CameraManager cameraManager = (CameraManager)HSCoreUtil.getContext().getSystemService("camera");
                String[] cameraIdList = cameraManager.getCameraIdList();
                if (cameraIdList.length > 0) {
                    numberOfCameras = cameraIdList.length;
                }
            } else {
                int camNum = Camera.getNumberOfCameras();
                if (camNum > 0) {
                    numberOfCameras = camNum;
                }
            }
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return Integer.toHexString(numberOfCameras);
    }

    private static String getPhoneHeightWidth() {
        if (!"phone_height".equals(phoneHeight)) {
            return phoneHeight;
        }
        try {
            int i = AntiFraudUtil.encryptInt(PostConstant.getScreenWidth(), PostConstant.getScreenHeight());
            phoneHeight = Integer.toHexString(i);
        }
        catch (Exception e) {
            phoneHeight = "";
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return phoneHeight;
    }

    private static String getTotalMemory() {
        if (!AntiFraudUtil.isOneBitOpen(24)) {
            return Integer.toHexString(0);
        }
        if (isTotalMemoryLoaded) {
            return Integer.toHexString(totalMemory);
        }
        isTotalMemoryLoaded = true;
        String str1 = "/proc/meminfo";
        try (FileReader localFileReader = new FileReader(str1);
             BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);){
            String str2 = localBufferedReader.readLine();
            String[] arrayOfString = str2.split("\\s+");
            int initialMemory = Integer.parseInt(arrayOfString[1]);
            totalMemory = initialMemory / 1024;
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        return Integer.toHexString(totalMemory);
    }

    private static String getAvailableMemory() {
        try {
            ActivityManager am = (ActivityManager)HSCoreUtil.getContext().getSystemService("activity");
            ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
            am.getMemoryInfo(mi);
            return Integer.toHexString((int)(mi.availMem / 0x100000L));
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
            return "";
        }
    }

    private static void getDiskSize() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            File dataFileDir = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(dataFileDir.getPath());
            long blockSize = stat.getBlockSizeLong();
            if (blockSize == 0L) {
                return;
            }
            long totalBlocks = stat.getBlockCountLong();
            long availableBlocks = stat.getAvailableBlocksLong();
            totalDiskSize = (int)(totalBlocks * blockSize / 0x100000L);
            availableDiskSize = (int)(availableBlocks * blockSize / 0x100000L);
        }
    }

    private static String getTotalDisk() {
        try {
            if (!AntiFraudUtil.isOneBitOpen(25)) {
                return Integer.toHexString(0);
            }
            if (isTotalDiskSizeLoaded) {
                return Integer.toHexString(totalDiskSize);
            }
            isTotalDiskSizeLoaded = true;
            AntiFraudUtil.getDiskSize();
            return Integer.toHexString(totalDiskSize);
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
            return "";
        }
    }

    private static String getAvailableDisk() {
        if (isTotalDiskSizeLoaded) {
            return Integer.toHexString(availableDiskSize);
        }
        try {
            return Integer.toHexString(availableDiskSize);
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
            return "";
        }
    }

    public static void saveAntiFraudSwitch(boolean isOpenAntiFraud) {
        AntiFraudUtil.log("cloud isOpenAntiFraud = " + isOpenAntiFraud);
        if (null != isOpenAntiFraudCache && isOpenAntiFraudCache == isOpenAntiFraud) {
            return;
        }
        isOpenAntiFraudCache = isOpenAntiFraud;
        if (isOpenAntiFraud && IS_PRELOAD_LOADING.get()) {
            AntiFraudUtil.log("saveAntiFraudSwitch --> non preload");
            AntiFraudUtil.preloadAntiFraud();
        }
        AdxPreferencesHelper.getInstance().putBoolean(IS_OPEN_ANTI_FRAUD_SP_KEY, isOpenAntiFraud);
    }

    public static boolean isOpenAntiFraud() {
        if (null == isOpenAntiFraudCache) {
            isOpenAntiFraudCache = AdxPreferencesHelper.getInstance().getBoolean(IS_OPEN_ANTI_FRAUD_SP_KEY, false);
        }
        return isOpenAntiFraudCache;
    }

    public static void saveAntiFraudSubfunctionControl(String antiFraudSubfunction) {
        AntiFraudUtil.log("cloud antiFraudSubfunctionControl = " + antiFraudSubfunction);
        if (!TextUtils.isEmpty((CharSequence)antiFraudSubfunctionControl) && antiFraudSubfunctionControl.equals(antiFraudSubfunction)) {
            return;
        }
        antiFraudSubfunctionControl = antiFraudSubfunction;
        AdxPreferencesHelper.getInstance().putString(ANTI_FRAUD_SUB_FUNCTION_SP_KEY, antiFraudSubfunctionControl);
    }

    public static String getAntiFraudSubfunctionControl() {
        if (TextUtils.isEmpty((CharSequence)antiFraudSubfunctionControl) && (antiFraudSubfunctionControl = AdxPreferencesHelper.getInstance().getString(ANTI_FRAUD_SUB_FUNCTION_SP_KEY, "")).isEmpty()) {
            antiFraudSubfunctionControl = "0";
        }
        return antiFraudSubfunctionControl;
    }

    private static boolean isOneBitOpen(int bit) {
        try {
            String antiFraudSubfunctionControl = AntiFraudUtil.getAntiFraudSubfunctionControl();
            if (antiFraudSubfunctionControl.length() < bit + 1) {
                return true;
            }
            StringBuilder sb = new StringBuilder(antiFraudSubfunctionControl);
            String sensorBit = (antiFraudSubfunctionControl = sb.reverse().toString()).charAt(bit) + "";
            return !sensorBit.equals("1");
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean isTwoBitOpen(int startBit) {
        try {
            StringBuilder sb;
            String sensorBit;
            String antiFraudSubfunctionControl = AntiFraudUtil.getAntiFraudSubfunctionControl();
            if (antiFraudSubfunctionControl.equals("1")) {
                antiFraudSubfunctionControl = "01";
            }
            return !(sensorBit = (antiFraudSubfunctionControl = (sb = new StringBuilder(antiFraudSubfunctionControl)).reverse().toString()).substring(startBit, startBit + 2)).equals("10");
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void preloadAntiFraud() {
        if (!AntiFraudUtil.isOpenAntiFraud()) {
            AntiFraudUtil.log("preloadAntiFraud --> cloud close");
            return;
        }
        try {
            if (!AntiFraudUtil.isOneBitOpen(26)) {
                SensorUtil.register();
            }
            AntiFraudUtil.getAntiFraudFullBundle();
            IS_PRELOAD_LOADING.set(false);
            AntiFraudUtil.log("preloadAntiFraud --> Initialize set tag IS_PRELOAD_LOADING = false");
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
    }

    public static void setAntiFraudFullString(Bundle bundle) {
        if (null == bundle) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)antiFraudFullString)) {
            bundle.putString("fraud_data_set", antiFraudFullString);
            return;
        }
        if (!AntiFraudUtil.isOpenAntiFraud()) {
            AntiFraudUtil.log("======= setAntiFraudFullString serve close =========");
            return;
        }
        try {
            if (!IS_PRELOAD_LOADING.get()) {
                boolean finish = SensorUtil.getInstance().isFinish();
                ANTI_FRAUD_FULL_BUNDLE.putAll(SensorUtil.getSensorBundle());
                String antiFraudString = AntiFraudUtil.getAntiFraudString(ANTI_FRAUD_FULL_BUNDLE);
                bundle.putString("fraud_data_set", antiFraudString);
                if (finish) {
                    ANTI_FRAUD_FULL_BUNDLE.clear();
                    antiFraudFullString = antiFraudString;
                }
            } else {
                bundle.putString("fraud_data_set", "");
            }
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
            bundle.putString("fraud_data_set", "");
        }
    }

    private static String getAntiFraudString(Bundle bundle) {
        if (null == bundle) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            Set keySet = bundle.keySet();
            sb.append("bn").append(TAG_VALUE).append(AntiFraudUtil.getCurrentBtName());
            for (String key : keySet) {
                Object ob = bundle.get(key);
                if (ob instanceof String) {
                    if (TextUtils.isEmpty((CharSequence)((String)ob))) {
                        ob = "\"\"";
                    }
                    sb.append(TAG_KEY).append(key).append(TAG_VALUE).append(ob);
                    continue;
                }
                if (ob instanceof Float) {
                    sb.append(TAG_KEY).append(key).append(TAG_VALUE).append(ob);
                    continue;
                }
                if (ob instanceof float[]) {
                    sb.append(TAG_KEY).append(key).append(TAG_VALUE).append(Arrays.toString((float[])ob));
                    continue;
                }
                if (!(ob instanceof String[])) continue;
                sb.append(TAG_KEY).append(key).append(TAG_VALUE).append(Arrays.toString((String[])ob));
            }
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
            sb.append("");
        }
        return AESUtils.encrypt(sb.toString());
    }

    private static void getAntiFraudFullBundle() {
        Bundle bundle = ANTI_FRAUD_FULL_BUNDLE;
        bundle.putString("bbv", AntiFraudUtil.getBaseBandVersion());
        bundle.putString("bt", AntiFraudUtil.getBootTime());
        bundle.putString("phn", AntiFraudUtil.getPhoneName());
        bundle.putString("si", AntiFraudUtil.getSsid());
        bundle.putStringArray("bl", AntiFraudUtil.getWifiList());
        bundle.putString("sb", AntiFraudUtil.getScreenBrightnessCapacity());
        bundle.putString("bpc", AntiFraudUtil.getBatteryPercent());
        bundle.putString("ct", AntiFraudUtil.getChargeType());
        bundle.putString("rn", AntiFraudUtil.getRomName());
        bundle.putString("rv", AntiFraudUtil.getRomVersion());
        bundle.putString("rb", AntiFraudUtil.getRomBuildTime());
        bundle.putString("oa", AntiFraudUtil.getOsApi());
        bundle.putString("bi", AntiFraudUtil.getBuildId());
        bundle.putString("cc", AntiFraudUtil.getCpuCores());
        bundle.putString("ccf", AntiFraudUtil.getCpuCoresCnt());
        bundle.putString("ca", AntiFraudUtil.getCpuAbi());
        bundle.putString("ck", AntiFraudUtil.getCpuKernel());
        bundle.putString("bd", AntiFraudUtil.getBoard());
        bundle.putString("hw", AntiFraudUtil.getHardWare());
        bundle.putString("fp", AntiFraudUtil.getFingerPrint());
        bundle.putString("noc", AntiFraudUtil.getNumberOfCameras());
        bundle.putString("ps", AntiFraudUtil.getPhoneHeightWidth());
        bundle.putString("tm", AntiFraudUtil.getTotalMemory());
        bundle.putString("td", AntiFraudUtil.getTotalDisk());
        bundle.putString("am", AntiFraudUtil.getAvailableMemory());
        bundle.putString("ad", AntiFraudUtil.getAvailableDisk());
        bundle.putString("cp", Integer.toHexString(AntiFraudUtil.getCpInt()));
    }

    public static String getAntiFraudLiteString() {
        if (!TextUtils.isEmpty((CharSequence)antiFraudLiteString)) {
            return antiFraudLiteString;
        }
        if (!AntiFraudUtil.isOpenAntiFraud()) {
            AntiFraudUtil.log("=========== getAntiFraudLiteString server close ===========");
            return "";
        }
        if (IS_PRELOAD_LOADING.get()) {
            return "";
        }
        try {
            Bundle bundle = new Bundle();
            bundle.putString("phn", AntiFraudUtil.getPhoneName());
            bundle.putString("bt", AntiFraudUtil.getBootTime());
            bundle.putString("si", AntiFraudUtil.getSsid());
            bundle.putStringArray("bl", AntiFraudUtil.getWifiList());
            bundle.putString("sb", AntiFraudUtil.getScreenBrightnessCapacity());
            bundle.putString("bpc", AntiFraudUtil.getBatteryPercent());
            bundle.putString("rn", AntiFraudUtil.getRomName());
            bundle.putString("rv", AntiFraudUtil.getRomVersion());
            bundle.putString("rb", AntiFraudUtil.getRomBuildTime());
            bundle.putString("oa", AntiFraudUtil.getOsApi());
            bundle.putString("cp", Integer.toHexString(AntiFraudUtil.getCpInt()));
            antiFraudLiteString = AntiFraudUtil.getAntiFraudString(bundle);
        }
        catch (Exception e) {
            AntiFraudUtil.log(Log.getStackTraceString((Throwable)e));
        }
        if (TextUtils.isEmpty((CharSequence)antiFraudLiteString)) {
            antiFraudLiteString = "";
        }
        return antiFraudLiteString;
    }

    private static void initBatteryBroadcast() {
        if (batteryBroadcast == null) {
            try {
                batteryBroadcastReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        Log.i((String)AntiFraudUtil.TAG, (String)"batteryBroadcastReceiver receive");
                    }
                };
                batteryBroadcast = Build.VERSION.SDK_INT >= 33 ? HSCoreUtil.getContext().registerReceiver(batteryBroadcastReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"), 2) : HSCoreUtil.getContext().registerReceiver(batteryBroadcastReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void destroyBatteryBroadcast() {
        batteryBroadcast = null;
        if (batteryBroadcastReceiver != null) {
            HSCoreUtil.getContext().unregisterReceiver(batteryBroadcastReceiver);
            batteryBroadcastReceiver = null;
        }
    }
}

