/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import java.lang.reflect.Method;

public class HSScreenUtil {
    private static DisplayMetrics getDisplayMetrics() {
        if (HSCoreUtil.getContext() == null) {
            return null;
        }
        WindowManager windowManager = (WindowManager)HSCoreUtil.getContext().getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        try {
            Class<?> cls = Class.forName("android.view.Display");
            Method method = cls.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, dm);
            return dm;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return null;
        }
    }

    public static int getWinWidth() {
        if (HSCoreUtil.getContext() == null) {
            return -1;
        }
        DisplayMetrics dm = HSScreenUtil.getDisplayMetrics();
        return dm.widthPixels;
    }

    public static int getWinHeight() {
        if (HSCoreUtil.getContext() == null) {
            return -1;
        }
        DisplayMetrics dm = HSScreenUtil.getDisplayMetrics();
        return dm.heightPixels;
    }

    public static int getScreenOrientation() {
        if (HSCoreUtil.getContext() == null || HSCoreUtil.getContext().getResources() == null) {
            return 0;
        }
        Configuration mConfiguration = HSCoreUtil.getContext().getResources().getConfiguration();
        return mConfiguration.orientation;
    }

    public static int getDensityDpi() {
        try {
            DisplayMetrics dm = HSScreenUtil.getDisplayMetrics();
            return dm == null ? -1 : dm.densityDpi;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static float getDensity() {
        try {
            DisplayMetrics dm = HSScreenUtil.getDisplayMetrics();
            return dm == null ? -1.0f : dm.density;
        }
        catch (Exception e) {
            return -1.0f;
        }
    }

    public static float getDensityScale() {
        try {
            DisplayMetrics dm = HSScreenUtil.getDisplayMetrics();
            return dm == null ? -1.0f : dm.scaledDensity;
        }
        catch (Exception e) {
            return -1.0f;
        }
    }

    public static int dip2px(float dpValue) {
        float scale = HSScreenUtil.getDensity();
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(float pxValue) {
        float scale = HSScreenUtil.getDensity();
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(float spValue) {
        float fontScale = HSScreenUtil.getDensityScale();
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int px2sp(float pxValue) {
        float fontScale = HSScreenUtil.getDensityScale();
        return (int)(pxValue / fontScale + 0.5f);
    }
}

