package com.cloud.sdk.commonutil.athena;

import static com.cloud.sdk.commonutil.util.CommonLogUtil.TAG;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.cloud.sdk.commonutil.BuildConfig;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.GPSTracker;
import com.cloud.sdk.commonutil.util.HSScopeHelper;
import com.cloud.sdk.commonutil.util.UserAgentUtil;
import com.transsion.ga.AthenaAnalytics;

import java.util.List;

/**
 * athena上报新开一个线程
 */
public class AthenaUtil {
    public static String vaid;
    /**
     * 上报埋点新开一个子线程
     *
     * @param runnable
     */
    public static void trackInNewThread(final Runnable runnable) {
        HSScopeHelper.INSTANCE.runWorkThread(runnable);
    }

    /**
     * @return 获取公参
     */
    public static Bundle getBundle(Bundle bundle) {
        long start = 0;
        if (BuildConfig.DEBUG) {
            start = System.currentTimeMillis();
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("session_id", PostConstant.getSessionId());
        bundle.putString("sdk_version", PostConstant.getSdkVersion());
        bundle.putInt("sdk_version_int", PostConstant.getSdkVersionCode());
        bundle.putString("user_agent", UserAgentUtil.getUserAgent());
        bundle.putInt("type", PostConstant.getType());
        bundle.putString("make", PostConstant.getMake());
        bundle.putString("ostype", "Android");
        bundle.putInt("screen_width", PostConstant.getScreenWidth());
        bundle.putInt("screen_height", PostConstant.getScreenHeight());
        bundle.putInt("screen_density", PostConstant.getScreenDensity());
        bundle.putString("base_station", DeviceUtil.getGsmCellLocation());
        bundle.putDouble("latitude", GPSTracker.getLatitude());
        bundle.putDouble("longitude", GPSTracker.getLongitude());
        bundle.putLong("coordtime", GPSTracker.getCoordTime());
        // 143 新增 oneid
        bundle.putString("oneid",DeviceUtil.getOneId());
        bundle.putInt("turn_off_per_ads", DeviceUtil.getGaidStatus());
        if(TextUtils.isEmpty(vaid)){
            try {
                AthenaUtil.vaid = AthenaAnalytics.getAppVAID(HSCoreUtil.getContext(), true);
            } catch (Exception e) {
                CommonLogUtil.Log().e(TAG,"getAppVAID "+ Log.getStackTraceString(e));
            }
        }
        bundle.putString("vaid",vaid);
        bundle.putString("gaid", DeviceUtil.getGAId());
        if (BuildConfig.DEBUG) {
            CommonLogUtil.Log().d("","AthenaTracker getBundle time = " + (System.currentTimeMillis() - start)+" bundle = "+ bundle);
        }
        return bundle;
    }

    /**
     * @param logEnable 埋点开关
     * @param value 目标值
     * @return true：开启 false：关闭
     */
    public static boolean isNeedTrack(List<String> logEnable, String value){
       if (logEnable == null || logEnable.isEmpty()) {
           return false;
       }
       return logEnable.contains(value);
    }
}
