package com.cloud.sdk.commonutil.deviceinfo;

import android.content.Context;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.HSCoreUtil;

public class HSDeviceInfo {
    private static String mGAId = "";

    public HSDeviceInfo() {
    }

    public static String getGAId() {
        if (mGAId == null || mGAId.length() == 0) {
            (new Thread(() -> {
                try {
                    HSAdvertisingIdClient.AdInfo adInfo = HSAdvertisingIdClient.getAdvertisingIdInfo(HSCoreUtil.getContext());
                    HSDeviceInfo.mGAId = adInfo.getId();
                    Log.i(CommonLogUtil.TAG, "advertisingId is " + HSDeviceInfo.mGAId);
                } catch (Exception var2) {
                    var2.printStackTrace();
                }
            })).start();
        }

        return mGAId;
    }

    public static boolean isPad() {
        try {
            Context context = HSCoreUtil.getContext();
            if (context.getResources() != null) {
                return (context.getResources().getConfiguration().screenLayout & 15) >= 3;
            } else {
                return false;
            }
        } catch (Exception e) {
            return false;
        }
    }

    public static String getSimOperator() {
        try {
            Context context = HSCoreUtil.getContext();
            TelephonyManager tm = (TelephonyManager)context.getSystemService(Context.TELEPHONY_SERVICE);
            return null == tm ? "" : tm.getSimOperator();
        } catch (Exception var2) {
            return "";
        }
    }
}

