package com.cloud.sdk.commonutil.pool;

import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadPoolExecutor;

public class HSHttpPoolManager implements HSPoolManagerImpl {
    private static volatile HSHttpPoolManager mInstance;
    private ThreadPoolExecutor executor;

    public HSHttpPoolManager() {
    }

    public static HSHttpPoolManager getInstance() {
        if (mInstance == null) {
            Class var0 = HSHttpPoolManager.class;
            synchronized(HSHttpPoolManager.class) {
                if (mInstance == null) {
                    mInstance = new HSHttpPoolManager();
                    mInstance.executor = HSPoolExecutor.newSourceExecutor();
                }
            }
        }

        return mInstance;
    }

    public void addTask(Runnable newTask) {
        if (this.executor != null) {
            if (this.executor.isShutdown()) {
                this.executor.prestartAllCoreThreads();
            }

            this.executor.execute(newTask);
        }

    }

    public void destroy() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            this.executor = null;
        }

    }

    public void purge() {
        if (this.executor != null) {
            this.executor.purge();
        }

    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }

    }

    public void execute(WeakReference<Runnable> request) {
        Runnable runnable = (Runnable)request.get();
        if (runnable != null) {
            this.addTask(runnable);
        }

    }
}

