package com.cloud.sdk.commonutil.pool;

import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadPoolExecutor;

public class HSPoolManager implements HSPoolManagerImpl {
    private static volatile HSPoolManager mInstance;
    private ThreadPoolExecutor executor;
    private static ThreadPoolExecutor sDefaultExecutor;

    public HSPoolManager() {
    }

    public static HSPoolManager getInstance() {
        if (mInstance == null) {
            Class var0 = HSPoolManager.class;
            synchronized(HSPoolManager.class) {
                if (mInstance == null) {
                    mInstance = new HSPoolManager();
                    mInstance.executor = (ThreadPoolExecutor)(sDefaultExecutor != null ? sDefaultExecutor : HSPoolExecutor.newTranssionExecutor());
                }
            }
        }

        return mInstance;
    }

    public static synchronized HSPoolManager getInstance(int poolSize) {
        if (mInstance == null) {
            Class var1 = HSPoolManager.class;
            synchronized(HSPoolManager.class) {
                if (mInstance == null) {
                    mInstance = new HSPoolManager();
                    mInstance.executor = (ThreadPoolExecutor)(sDefaultExecutor != null ? sDefaultExecutor : HSPoolExecutor.newTranssionExecutor(poolSize));
                }
            }
        }

        return mInstance;
    }

    public static void setDefaultExecutor(ThreadPoolExecutor executor) {
        sDefaultExecutor = executor;
    }

    public void addTask(Runnable newTask) {
        if (this.executor != null) {
            if (this.executor.isShutdown()) {
                this.executor.prestartAllCoreThreads();
            }

            this.executor.execute(newTask);
        }

    }

    public void destroy() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            this.executor = null;
        }

    }

    public void purge() {
        if (this.executor != null) {
            this.executor.purge();
        }

    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }

    }

    public void execute(WeakReference<Runnable> request) {
        Runnable runnable = (Runnable)request.get();
        if (runnable != null) {
            this.addTask(runnable);
        }

    }
}

