package com.cloud.sdk.commonutil.util;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 处理应用相关的工具类
 */
public class ApplicationUtil {
    private static String firstInstallTime;

    private static final int isHadQueryPackagePermission = -1;// -1：还没有判断  1：有权限  0：无权限

    private ApplicationUtil(){

    }

    /**
     * 获取客户端首次安装时间（时间戳）
     */
    public static String getInstallTime() {
        if (TextUtils.isEmpty(firstInstallTime) && HSCoreUtil.getContext().getApplicationContext() != null) {
            try {
                PackageManager manager = HSCoreUtil.getContext().getApplicationContext().getPackageManager();
                PackageInfo info = manager.getPackageInfo(HSCoreUtil.getContext().getApplicationContext().getPackageName(), 0);
                //获取应用第一次安装的时间
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS Z");
                Date date = new Date(info.firstInstallTime);
                firstInstallTime = format.format(date);

            } catch (Exception e) {
                CommonLogUtil.Log().d(CommonLogUtil.TAG,"get installTime is error: " + e.getMessage());
            }
        }
        return firstInstallTime;
    }

}