package com.cloud.sdk.commonutil.util

import android.os.Looper
import android.util.Log
import com.cloud.sdk.commonutil.BuildConfig
import com.cloud.sdk.commonutil.pool.HSPoolManager
import kotlinx.coroutines.CoroutineExceptionHandler
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

object HSScopeHelper {
    /**是否允许SDK使用独立的IO线程池，默认使用IO协程*/
    @kotlin.jvm.JvmField
    var isAllowSeparetedThreadPool = false
    /**广告的后台work thread*/
    fun runWorkThread(runnable: Runnable) {
        if(Looper.myLooper() == HandlerThreadFactory.getHandler("hs_work_thread")?.looper){
            runnable.run()
        }else{
            HandlerThreadFactory.getHandler("hs_work_thread")?.post(runnable)
        }

    }
    fun runWorkThread(runnable: Runnable, delay: Long) {
        HandlerThreadFactory.getHandler("hs_work_thread")?.postDelayed(runnable, delay)
    }
    fun <T> runWorkThread(runnable: () -> T, callback: (HSResult<T>) -> Unit) {
        if(Looper.myLooper() == HandlerThreadFactory.getHandler("hs_work_thread")?.looper){
            try {
                val result = runnable.invoke()
                callback(HSResult.Success(result))
            } catch (t: Throwable) {
                callback(HSResult.Failure(t))
            }
        }else {
            HandlerThreadFactory.getHandler("hs_work_thread")?.post {
                try {
                    val result = runnable.invoke()
                    callback(HSResult.Success(result))
                } catch (t: Throwable) {
                    callback(HSResult.Failure(t))
                }
            }
        }
    }

    /**广告请求线程*/
    fun runFetchAdThread(runnable: Runnable){
        if(Looper.myLooper() == HandlerThreadFactory.getHandler("hs_fetch_ad_thread")?.looper){
            runnable.run()
        }else {
            HandlerThreadFactory.getHandler("hs_fetch_ad_thread")?.post(runnable)
        }
    }
    fun runFetchAdThread(runnable: Runnable,delay: Long){
        HandlerThreadFactory.getHandler("hs_fetch_ad_thread")?.postDelayed(runnable, delay)
    }
    /**
     * 移除 hs_fetch_ad_thread 中的 runnable
     */
    fun removeFetchAdThreadHandlerCallback(runnable: Runnable){
        try {
            HandlerThreadFactory.getHandler("hs_fetch_ad_thread")?.removeCallbacks(runnable)
        }catch (t: Throwable){

        }
    }


    fun runIOThread(runnable: Runnable) {
        if(isAllowSeparetedThreadPool){
            HSPoolManager.getInstance().addTask(runnable)
        }else{
            if (BuildConfig.DEBUG) {
                ioScope.launch {
                    runnable.run()
                }
            } else {
                ioScope.launch(ioExceptionHandler) {
                    runnable.run()
                }
            }
        }

    }
//    fun runNewThread(runnable: Runnable,delay: Long) {
//        defulatScope.launch(ioExceptionHandler) {
//            delay(delay)
//            runnable.run()
//        }
//    }
//todo yanglin 新增 UI
    fun runUIThread(runnable: Runnable){
        uiScope.launch {
            runnable.run()
        }
    }

    val ioExceptionHandler = CoroutineExceptionHandler { coroutineContext, exception ->
        Log.d("ExceptionHandler", "CoroutineExceptionHandler: ${exception.message}")
    }
    val uiScope = CoroutineScope(Dispatchers.Main)
    val ioScope = CoroutineScope(Dispatchers.IO)
    val defulatScope = CoroutineScope(Dispatchers.Default)
}


sealed class HSResult<out T> {
    data class Success<out T>(val value: T) : HSResult<T>()
    data class Failure(val exception: Throwable) : HSResult<Nothing>()
}