package com.cloud.sdk.commonutil.util;

import static android.content.res.Configuration.ORIENTATION_UNDEFINED;

import android.content.Context;
import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

import java.lang.reflect.Method;

public class HSScreenUtil {
    public HSScreenUtil() {
    }

    private static DisplayMetrics getDisplayMetrics() {
        if (HSCoreUtil.getContext() == null) {
            return null;
        } else {
            WindowManager windowManager = (WindowManager) HSCoreUtil.getContext().getSystemService(Context.WINDOW_SERVICE);
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics dm = new DisplayMetrics();

            try {
                Class cls = Class.forName("android.view.Display");
                Method method = cls.getMethod("getRealMetrics", DisplayMetrics.class);
                method.invoke(display, dm);
                return dm;
            } catch (Exception var5) {
                var5.printStackTrace();
                return null;
            }
        }
    }

    public static int getWinWidth() {
        if (HSCoreUtil.getContext() == null) {
            return -1;
        } else {
            DisplayMetrics dm = getDisplayMetrics();
            return dm.widthPixels;
        }
    }

    public static int getWinHeight() {
        if (HSCoreUtil.getContext() == null) {
            return -1;
        } else {
            DisplayMetrics dm = getDisplayMetrics();
            return dm.heightPixels;
        }
    }

    public static int getScreenOrientation() {
        if (HSCoreUtil.getContext() == null || HSCoreUtil.getContext().getResources() == null) {
            return ORIENTATION_UNDEFINED;
        } else {
            Configuration mConfiguration = HSCoreUtil.getContext().getResources().getConfiguration();
            return mConfiguration.orientation;
        }
    }

    public static int getDensityDpi() {
        try {
            DisplayMetrics dm = getDisplayMetrics();
            return dm == null ? -1 : dm.densityDpi;
        } catch (Exception e) {
            return -1;
        }
    }

    public static float getDensity() {
        try {
            DisplayMetrics dm = getDisplayMetrics();
            return dm == null ? -1.0F : dm.density;
        } catch (Exception e) {
            return -1.0F;
        }

    }

    public static float getDensityScale() {
        try {
            DisplayMetrics dm = getDisplayMetrics();
            return dm == null ? -1.0F : dm.scaledDensity;
        }catch (Exception e){
            return -1.0F;
        }

    }

    public static int dip2px(float dpValue) {
        float scale = getDensity();
        return (int)(dpValue * scale + 0.5F);
    }

    public static int px2dip(float pxValue) {
        float scale = getDensity();
        return (int)(pxValue / scale + 0.5F);
    }

    public static int sp2px(float spValue) {
        float fontScale = getDensityScale();
        return (int)(spValue * fontScale + 0.5F);
    }

    public static int px2sp(float pxValue) {
        float fontScale = getDensityScale();
        return (int)(pxValue / fontScale + 0.5F);
    }
}
