package com.cloud.sdk.commonutil.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.Nullable;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @author wenjing.luo
 * @date :2022/5/26 15:13
 * @description:
 */
public class LifecycleUtil {

    private static final String TAG = "LifecycleUtil";

    private static WeakReference<Activity> topActivity = new WeakReference<>(null);

    private static boolean isRegistered = false;

    /**
     * 监听整个应用的生命周期
     */
    public static void registerActivityLifecycleCallbacks(Application application) {
        if (null == application || isRegistered) {
            return;
        }
        isRegistered = true;

        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {

            @Override
            public void onActivityCreated(Activity activity, @Nullable Bundle savedInstanceState) {
            }

            @Override
            public void onActivityStarted(Activity activity) {
            }

            @Override
            public void onActivityResumed(Activity activity) {
                topActivity.clear();
                topActivity = new WeakReference<>(activity);
            }

            @Override
            public void onActivityPaused(Activity activity) {
            }

            @Override
            public void onActivityStopped(Activity activity) {
            }

            @Override
            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            @Override
            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    /**
     * 获取最新的activity
     * @return
     */
    public static Activity getTopActivity() {
        Activity act = null;

        if (topActivity != null) {
            act = topActivity.get();
        }

        if (isActivityAlive(act)) {
            CommonLogUtil.Log().i(TAG,  "topActivity = " + act.getClass().getSimpleName());

            return act;
        } else {
            CommonLogUtil.Log().i(TAG, "getActivitiesByReflect");

            List<Activity> activityList = getActivitiesByReflect();
            for (Activity activity: activityList) {
                if (!isActivityAlive(activity)) {
                    continue;
                }
                CommonLogUtil.Log().i(TAG, "getActivitiesByReflect topActivity = " + activity.getClass().getSimpleName());

                return activity;
            }
        }
        CommonLogUtil.Log().i(TAG, "Did not get topActivity");
        return null;
    }

    private static boolean isActivityAlive(final Activity activity) {
        return activity != null && !activity.isFinishing() && !activity.isDestroyed();
    }

    /**
     * 反射方式获取所有的activity
     * @return
     */
    private static List<Activity> getActivitiesByReflect() {
        LinkedList<Activity> list = new LinkedList<>();
        Activity topActivity = null;
        try {
            Object activityThread = getActivityThread();
            if (activityThread == null) {
                return list;
            }
            Field mActivitiesField = activityThread.getClass().getDeclaredField("mActivities");
            mActivitiesField.setAccessible(true);
            Object mActivities = mActivitiesField.get(activityThread);
            if (!(mActivities instanceof Map)) {
                return list;
            }
            Map<Object, Object> binder_activityClientRecord_map = (Map<Object, Object>) mActivities;
            for (Object activityRecord : binder_activityClientRecord_map.values()) {
                Class activityClientRecordClass = activityRecord.getClass();
                Field activityField = activityClientRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity) activityField.get(activityRecord);
                if (topActivity == null) {
                    Field pausedField = activityClientRecordClass.getDeclaredField("paused");
                    pausedField.setAccessible(true);
                    if (!pausedField.getBoolean(activityRecord)) {
                        topActivity = activity;
                    } else {
                        list.add(activity);
                    }
                } else {
                    list.add(activity);
                }
            }
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getActivitiesByReflect: " + e.getMessage());
        }
        if (topActivity != null) {
            list.addFirst(topActivity);
        }
        return list;
    }

    private static Object getActivityThread() {
        Object activityThread = getActivityThreadInActivityThreadStaticField();
        if (activityThread != null) return activityThread;
        return getActivityThreadInActivityThreadStaticMethod();
    }

    private static Object getActivityThreadInActivityThreadStaticField() {
        try {
            Class activityThreadClass = Class.forName("android.app.ActivityThread");
            Field sCurrentActivityThreadField = activityThreadClass.getDeclaredField("sCurrentActivityThread");
            sCurrentActivityThreadField.setAccessible(true);
            return sCurrentActivityThreadField.get(null);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getActivityThreadInActivityThreadStaticField: " + e.getMessage());
            return null;
        }
    }

    private static Object getActivityThreadInActivityThreadStaticMethod() {
        try {
            @SuppressLint("PrivateApi")
            Class activityThreadClass = Class.forName("android.app.ActivityThread");
            return activityThreadClass.getMethod("currentActivityThread").invoke(null);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getActivityThreadInActivityThreadStaticMethod: " + e.getMessage());
            return null;
        }
    }
}
