package com.cloud.sdk.commonutil.util;



/**
 * test需要，记录步骤信息
 */
public class RecordLog {
    private static LogListener logListener;
    //云控配置信息
    public final static int LOG_CODE1 = 1;
    //请求广告流程
    public final static int LOG_CODE2 = 2;
    //广告填充结果
    public final static int LOG_CODE3 = 3;
    //离线广告缓存池信息
    public final static int LOG_CODE4 = 4;

    public static void setLogListener(LogListener listener) {
        logListener = listener;
    }

    public interface LogListener {
        void log(String msg, int code);
    }

    public static void LogMsg(String msg, int code) {
        Preconditions.runOnMainThread(() -> {
            if (logListener != null) {
                logListener.log(msg, code);
            }
        });
    }

    public static void destroy() {
        logListener = null;
    }
}
