package com.cloud.sdk.commonutil.util;
/* Top Secret */

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebSettings;

import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;

import java.util.Locale;


/**
 * usage
 *
 * @author peng.sun
 * @data 2017/06/29
 * ========================================
 * CopyRight (c) 2017 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class UserAgentUtil {

    private static final String USER_AGENT_KEY = "user_agent";

    private static String ua = "";

    private UserAgentUtil() {}

    public static String getUserAgent() {

        try {
            //  1. 从内存拿
            if (isValidUA(ua)) {
                CommonLogUtil.Log().d("UserAgentUtil", "The UA in memory is： " + ua);
                return ua;
            }

            // 2. 从磁盘拿
            ua = AdxPreferencesHelper.getInstance().getString(USER_AGENT_KEY);
            if (isValidUA(ua)) {
                CommonLogUtil.Log().d("UserAgentUtil", "The UA in sp is: " + ua);
                return ua;
            }

            // 3. 生成新的
            ua = createNewUserAgent();
            if (isValidUA(ua)) {
                CommonLogUtil.Log().d("UserAgentUtil", "The UA obtained from webview is：" + ua);
                AdxPreferencesHelper.getInstance().putString(USER_AGENT_KEY, ua);
                return ua;
            }

            // 4. 兜底
            String defaultUserAgent = getDefaultUserAgent();
            if (isValidUA(defaultUserAgent)) {
                CommonLogUtil.Log().d("UserAgentUtil", "The default UA is：" + defaultUserAgent);
                return defaultUserAgent;
            }
        } catch (Exception ignored) {}

        return "";
    }

    private static boolean isValidUA(String ua) {
        return (!TextUtils.isEmpty(ua))
                && (ua.length() > 10
                && !ua.contains("windows NT")
                && !ua.contains("Macintosh")
                && !ua.contains("Dalvik"));
    }

    private static String createNewUserAgent() {
        // 注意：WebSettings.getDefaultUserAgent 大概有 200ms 的耗时
        try {
            if (HSCoreUtil.isInit()){
                long intervalTime = System.currentTimeMillis() - HSCoreUtil.getInitTime();
                if (intervalTime >= 5000) {
                    return WebSettings.getDefaultUserAgent(HSCoreUtil.getContext());
                } else {
                    CommonLogUtil.Log().w("UserAgentUtil","createNewUserAgent intervalTime is " + intervalTime);
                }
            }
        }catch (Throwable e){
            CommonLogUtil.Log().e( "createNewUserAgent is error , error infor is :=" +e.getMessage());
        }
        return "";
    }

    public static void init() {
        try {
            if (TextUtils.isEmpty(ua)) {
//                ua = WebSettings.getDefaultUserAgent(HSCoreUtil.getContext());
                ua = getDefaultUserAgent();
                //AdLogUtil.Log().d(AdLogUtil.TAG,"ua is not empty");
            }
        } catch (Throwable e) {
            CommonLogUtil.Log().e( "init is error , error infor is :=" + Log.getStackTraceString(e));
        }
    }

    /**
     * getUserAgent
     *
     * @return
//     */
//    public static String getUserAgent() {
//        try {
//            if (checkAgent()) {
//                //AdLogUtil.Log().d(AdLogUtil.TAG,"call getUserAgent to get ua ,ua :=" + ua);
//                return ua;
//            }
//            //AdLogUtil.Log().d(AdLogUtil.TAG,"ua is empty");
//        } catch (Throwable e) {
//            CommonLogUtil.Log().e( "UserAgentUtil getUserAgent is error , error infor is :=" + Log.getStackTraceString(e));
//        }
//        return "";
//    }

    /**
     * 获取默认UA
     *
     * @return
     */
    private static String getDefaultUserAgent() {
        final String UA = "Mozilla/5.0 (Linux; Android %s;) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/55.0.2883.91 Mobile Safari/537.36";
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer();
        // Add version
        final String version = Build.VERSION.RELEASE.replace(";", "");;
        if (version.length() > 0) {
            buffer.append(version);
        } else {
            // default to "1.0"
            buffer.append("1.0");
        }
        buffer.append("; ");

        final String language = locale.getLanguage();
        if (language != null) {
            buffer.append(language.toLowerCase());
            final String country = locale.getCountry();
            if (country != null) {
                buffer.append("-");
                buffer.append(country.toLowerCase());
            }
        } else {
            // default to "en"
            buffer.append("en");
        }

        // add the model for the release build
        if ("REL".equals(Build.VERSION.CODENAME)) {
            final String model = Build.MODEL;
            if (model.length() > 0) {
                buffer.append("; ");
                buffer.append(model);
            }
        }

        final String id = Build.ID;
        if (id.length() > 0) {
            buffer.append(" Build/");
            buffer.append(id);
        }

        return String.format(UA, buffer);
    }

    /**
     * 检测webview类型
     *
     * @return
     */
    private static boolean checkAgent() {
        try {
            if (TextUtils.isEmpty(ua)) {
                init();
            }
            if (!ua.contains("windows NT") && !ua.contains("Macintosh") && !ua.contains("Dalvik")) {
                return true;
            }
        } catch (Throwable e) {
            CommonLogUtil.Log().e( "checkAgent is error , error msg is :=" + Log.getStackTraceString(e));
        }
        return false;
    }
}
