package com.cloud.sdk.commonutil.util.imagerender

import android.annotation.SuppressLint
import android.graphics.BitmapFactory
import android.graphics.drawable.BitmapDrawable
import android.graphics.drawable.Drawable
import com.cloud.sdk.commonutil.util.CommonLogUtil
import com.cloud.sdk.commonutil.util.HSCoreUtil

interface ImageRenderable {
    fun getGifDrawableFromData(bytes: ByteArray): Drawable?
    fun activatedDrawable(drawable: Drawable?): Drawable?
}

object HisavanaImageRender {

    const val TAG = "HisavanaImageRender"

    @JvmStatic
    fun setup() {
        GlideRender.setup()
        GifDrawableRender.setup()
    }

    @JvmStatic
    fun getDrawableFromData(bytes: ByteArray?): Drawable? {
        if (bytes == null) return null

        try {
            val isGif = bytes.let { it.size > 1 && it[0].toInt() == 0x47 }

            return if (isGif) {
                getGifDrawableFromData(bytes)
            } else {
                getStaticDrawableFromData(bytes)
            }
        } catch (e: Exception) {
            CommonLogUtil.Log().w(TAG, "getDrawableFromData failed, error=${e.message}")
            return null
        }
    }

    // 获取 GifDrawable
    private fun getGifDrawableFromData(bytes: ByteArray): Drawable {
        return GlideRender.getGifDrawableFromData(bytes)
            ?: GifDrawableRender.getGifDrawableFromData(bytes)
            ?: getStaticDrawableFromData(bytes)
    }

    // 获取静态 Drawable
    @SuppressLint("UseKtx")
    private fun getStaticDrawableFromData(bytes: ByteArray): Drawable {
        val bitmap = BitmapFactory.decodeByteArray(bytes, 0, bytes.size)
        return BitmapDrawable(HSCoreUtil.getContext().resources, bitmap)
    }

    // 激活的Drawable。对于通过glide加载的Gif动图，Drawable需要激活动画
    @JvmStatic
    fun activatedDrawable(drawable: Drawable?): Drawable? {
        return GlideRender.activatedDrawable(drawable)
    }
}