/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Environment;
import androidx.annotation.NonNull;
import com.cloud.sdk.commonutil.deviceinfo.HSDeviceInfo;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.HSSharedPreferencesUtil;
import java.io.File;
import java.lang.reflect.Field;

public class HSCoreUtil {
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile Context context;
    private static volatile boolean isDebug;
    private static volatile boolean isInit;
    private static volatile long initTime;

    private HSCoreUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static synchronized void init(@NonNull Context context) {
        if (!HSCoreUtil.isInit()) {
            isInit = true;
            HSCoreUtil.context = context.getApplicationContext();
            HSDeviceInfo.getGAId();
            HSSharedPreferencesUtil.bindApplication(HSCoreUtil.getContext());
            initTime = System.currentTimeMillis();
            CommonLogUtil.Log().d("HSCoreUtil", "init time is " + initTime);
        }
    }

    public static void setContext(Context context) {
        try {
            HSCoreUtil.context = context.getApplicationContext();
        }
        catch (Throwable t) {
            CommonLogUtil.Log().e("context is null, please check it");
        }
    }

    public static boolean isInit() {
        return isInit && context != null;
    }

    public static Context getContext() {
        if (context == null) {
            CommonLogUtil.Log().e("u should init first");
        }
        return context;
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static void setDebug(boolean isDebug) {
        HSCoreUtil.isDebug = isDebug;
    }

    public static String getPkgName() {
        return HSCoreUtil.getContext().getPackageName();
    }

    public static File getExternalCacheDir(Context context) {
        boolean isUserRequired;
        File cacheDir = null;
        try {
            Field privateBoolField = Environment.class.getDeclaredField("sUserRequired");
            privateBoolField.setAccessible(true);
            Environment user = new Environment();
            isUserRequired = privateBoolField.getBoolean(user);
        }
        catch (Exception var6) {
            isUserRequired = true;
        }
        try {
            if (!isUserRequired) {
                cacheDir = context.getExternalCacheDir();
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return cacheDir;
    }

    public static String getVersionName() {
        String versionName = "";
        Context context = HSCoreUtil.getContext();
        if (context == null) {
            return versionName;
        }
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (pi != null) {
                versionName = pi.versionName;
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
        return versionName;
    }

    public static int getVersionCode() {
        int versionCode = -1;
        Context context = HSCoreUtil.getContext();
        if (context == null) {
            return versionCode;
        }
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (pi != null) {
                versionCode = pi.versionCode;
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
        return versionCode;
    }

    public static long getInitTime() {
        return initTime;
    }

    static {
        isInit = false;
        initTime = 0L;
    }
}

