/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/cloud/sdk/commonutil/util/HandlerThreadFactory;", "", "()V", "handlerMap", "", "", "Landroid/os/Handler;", "handlerThreadMap", "Landroid/os/HandlerThread;", "getHandler", "threadName", "getHandlerThread", "quitAllHandlerThreads", "", "quitHandlerThread", "commonutil_release"})
public final class HandlerThreadFactory {
    @NotNull
    public static final HandlerThreadFactory INSTANCE = new HandlerThreadFactory();
    @NotNull
    private static final Map<String, HandlerThread> handlerThreadMap = new HashMap();
    @NotNull
    private static final Map<String, Handler> handlerMap = new HashMap();

    private HandlerThreadFactory() {
    }

    private final synchronized HandlerThread getHandlerThread(String threadName) {
        HandlerThread handlerThread = handlerThreadMap.get(threadName);
        if (handlerThread == null) {
            handlerThread = new HandlerThread(threadName);
            handlerThread.start();
            handlerThreadMap.put(threadName, handlerThread);
        }
        return handlerThread;
    }

    @Nullable
    public final synchronized Handler getHandler(@NotNull String threadName) {
        HandlerThread handlerThread;
        Looper looper;
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Handler handler = handlerMap.get(threadName);
        if (handler == null && (looper = (handlerThread = this.getHandlerThread(threadName)).getLooper()) != null) {
            handler = new Handler(looper);
            handlerMap.put(threadName, handler);
        }
        return handler;
    }

    public final synchronized void quitHandlerThread(@NotNull String threadName) {
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        HandlerThread handlerThread = handlerThreadMap.get(threadName);
        if (handlerThread != null) {
            handlerThread.quitSafely();
            handlerThreadMap.remove(threadName);
        }
        handlerMap.remove(threadName);
    }

    public final synchronized void quitAllHandlerThreads() {
        for (HandlerThread handlerThread : handlerThreadMap.values()) {
            handlerThread.quitSafely();
        }
        handlerThreadMap.clear();
        handlerMap.clear();
    }
}

