/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebSettings;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import java.util.Locale;

public class UserAgentUtil {
    private static final String USER_AGENT_KEY = "user_agent";
    private static String ua = "";

    private UserAgentUtil() {
    }

    public static String getUserAgent() {
        try {
            if (UserAgentUtil.isValidUA(ua)) {
                CommonLogUtil.Log().d("UserAgentUtil", "The UA in memory is\uff1a " + ua);
                return ua;
            }
            ua = AdxPreferencesHelper.getInstance().getString(USER_AGENT_KEY);
            if (UserAgentUtil.isValidUA(ua)) {
                CommonLogUtil.Log().d("UserAgentUtil", "The UA in sp is: " + ua);
                return ua;
            }
            ua = UserAgentUtil.createNewUserAgent();
            if (UserAgentUtil.isValidUA(ua)) {
                CommonLogUtil.Log().d("UserAgentUtil", "The UA obtained from webview is\uff1a" + ua);
                AdxPreferencesHelper.getInstance().putString(USER_AGENT_KEY, ua);
                return ua;
            }
            String defaultUserAgent = UserAgentUtil.getDefaultUserAgent();
            if (UserAgentUtil.isValidUA(defaultUserAgent)) {
                CommonLogUtil.Log().d("UserAgentUtil", "The default UA is\uff1a" + defaultUserAgent);
                return defaultUserAgent;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static boolean isValidUA(String ua) {
        return !TextUtils.isEmpty((CharSequence)ua) && ua.length() > 10 && !ua.contains("windows NT") && !ua.contains("Macintosh") && !ua.contains("Dalvik");
    }

    private static String createNewUserAgent() {
        try {
            if (HSCoreUtil.isInit()) {
                long intervalTime = System.currentTimeMillis() - HSCoreUtil.getInitTime();
                if (intervalTime >= 5000L) {
                    return WebSettings.getDefaultUserAgent((Context)HSCoreUtil.getContext());
                }
                CommonLogUtil.Log().w("UserAgentUtil", "createNewUserAgent intervalTime is " + intervalTime);
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e("createNewUserAgent is error , error infor is :=" + e.getMessage());
        }
        return "";
    }

    public static void init() {
        try {
            if (TextUtils.isEmpty((CharSequence)ua)) {
                ua = UserAgentUtil.getDefaultUserAgent();
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e("init is error , error infor is :=" + Log.getStackTraceString((Throwable)e));
        }
    }

    private static String getDefaultUserAgent() {
        String id;
        String model;
        String UA = "Mozilla/5.0 (Linux; Android %s;) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/55.0.2883.91 Mobile Safari/537.36";
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer();
        String version = Build.VERSION.RELEASE.replace(";", "");
        if (version.length() > 0) {
            buffer.append(version);
        } else {
            buffer.append("1.0");
        }
        buffer.append("; ");
        String language = locale.getLanguage();
        if (language != null) {
            buffer.append(language.toLowerCase());
            String country = locale.getCountry();
            if (country != null) {
                buffer.append("-");
                buffer.append(country.toLowerCase());
            }
        } else {
            buffer.append("en");
        }
        if ("REL".equals(Build.VERSION.CODENAME) && (model = Build.MODEL).length() > 0) {
            buffer.append("; ");
            buffer.append(model);
        }
        if ((id = Build.ID).length() > 0) {
            buffer.append(" Build/");
            buffer.append(id);
        }
        return String.format("Mozilla/5.0 (Linux; Android %s;) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/55.0.2883.91 Mobile Safari/537.36", buffer);
    }

    private static boolean checkAgent() {
        try {
            if (TextUtils.isEmpty((CharSequence)ua)) {
                UserAgentUtil.init();
            }
            if (!(ua.contains("windows NT") || ua.contains("Macintosh") || ua.contains("Dalvik"))) {
                return true;
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e("checkAgent is error , error msg is :=" + Log.getStackTraceString((Throwable)e));
        }
        return false;
    }
}

