/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LifecycleUtil {
    private static final String TAG = "LifecycleUtil";
    private static WeakReference<Activity> topActivity = new WeakReference<Object>(null);
    private static boolean isRegistered = false;

    public static void registerActivityLifecycleCallbacks(Application application) {
        if (null == application || isRegistered) {
            return;
        }
        isRegistered = true;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, @Nullable Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                topActivity.clear();
                topActivity = new WeakReference<Activity>(activity);
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    public static Activity getTopActivity() {
        Activity act = null;
        if (topActivity != null) {
            act = (Activity)topActivity.get();
        }
        if (LifecycleUtil.isActivityAlive(act)) {
            CommonLogUtil.Log().i(TAG, "topActivity = " + act.getClass().getSimpleName());
            return act;
        }
        CommonLogUtil.Log().i(TAG, "getActivitiesByReflect");
        List<Activity> activityList = LifecycleUtil.getActivitiesByReflect();
        for (Activity activity : activityList) {
            if (!LifecycleUtil.isActivityAlive(activity)) continue;
            CommonLogUtil.Log().i(TAG, "getActivitiesByReflect topActivity = " + activity.getClass().getSimpleName());
            return activity;
        }
        CommonLogUtil.Log().i(TAG, "Did not get topActivity");
        return null;
    }

    private static boolean isActivityAlive(Activity activity) {
        return activity != null && !activity.isFinishing() && !activity.isDestroyed();
    }

    private static List<Activity> getActivitiesByReflect() {
        LinkedList<Activity> list = new LinkedList<Activity>();
        Activity topActivity = null;
        try {
            Object activityThread = LifecycleUtil.getActivityThread();
            if (activityThread == null) {
                return list;
            }
            Field mActivitiesField = activityThread.getClass().getDeclaredField("mActivities");
            mActivitiesField.setAccessible(true);
            Object mActivities = mActivitiesField.get(activityThread);
            if (!(mActivities instanceof Map)) {
                return list;
            }
            Map binder_activityClientRecord_map = (Map)mActivities;
            for (Object activityRecord : binder_activityClientRecord_map.values()) {
                Class<?> activityClientRecordClass = activityRecord.getClass();
                Field activityField = activityClientRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity)activityField.get(activityRecord);
                if (topActivity == null) {
                    Field pausedField = activityClientRecordClass.getDeclaredField("paused");
                    pausedField.setAccessible(true);
                    if (!pausedField.getBoolean(activityRecord)) {
                        topActivity = activity;
                        continue;
                    }
                    list.add(activity);
                    continue;
                }
                list.add(activity);
            }
        }
        catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getActivitiesByReflect: " + e.getMessage());
        }
        if (topActivity != null) {
            list.addFirst(topActivity);
        }
        return list;
    }

    private static Object getActivityThread() {
        Object activityThread = LifecycleUtil.getActivityThreadInActivityThreadStaticField();
        if (activityThread != null) {
            return activityThread;
        }
        return LifecycleUtil.getActivityThreadInActivityThreadStaticMethod();
    }

    private static Object getActivityThreadInActivityThreadStaticField() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Field sCurrentActivityThreadField = activityThreadClass.getDeclaredField("sCurrentActivityThread");
            sCurrentActivityThreadField.setAccessible(true);
            return sCurrentActivityThreadField.get(null);
        }
        catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getActivityThreadInActivityThreadStaticField: " + e.getMessage());
            return null;
        }
    }

    private static Object getActivityThreadInActivityThreadStaticMethod() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            return activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getActivityThreadInActivityThreadStaticMethod: " + e.getMessage());
            return null;
        }
    }
}

