/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import java.util.Set;

public class SensitiveUtil {
    public static final String TAG = "SensitiveUtil";

    public static boolean isSensitive(String title, String content) {
        if (!TextUtils.isEmpty((CharSequence)content) || !TextUtils.isEmpty((CharSequence)title)) {
            Set keywords = AdxPreferencesHelper.getInstance().getStringSet("sensitive_keywords");
            AdLogUtil.LOG.d(TAG, new Object[]{"Sensitive keywords is:=" + keywords});
            if (keywords != null) {
                for (String word : keywords) {
                    if (TextUtils.isEmpty((CharSequence)word)) continue;
                    if (SensitiveUtil.filter(content, word)) {
                        return true;
                    }
                    if (!SensitiveUtil.filter(title, word)) continue;
                    return true;
                }
            }
        }
        AdLogUtil.LOG.d(TAG, new Object[]{"sensitive check is pass"});
        return false;
    }

    public static boolean isWords(String key) {
        String regex = "^[a-z0-9A-Z]+$";
        return key.matches(regex);
    }

    public static boolean filter(String content, String key) {
        String[] strs;
        if (TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        if (!SensitiveUtil.isWords(key = key.toLowerCase())) {
            if (content.toLowerCase().trim().contains(key)) {
                AdLogUtil.LOG.d(TAG, new Object[]{"is sensitive ,word is: " + key});
                AdLogUtil.LOG.d(TAG, new Object[]{"is sensitive ,content is: " + content});
                return true;
            }
            return false;
        }
        for (String str : strs = content.split("[^a-zA-Z0-9]+")) {
            if (!TextUtils.equals((CharSequence)str.toLowerCase(), (CharSequence)key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSensitive(TaNativeInfo nativeInfo) {
        boolean contentIsSensitive = SensitiveUtil.isSensitive(nativeInfo.getTitle(), nativeInfo.getDescription());
        return contentIsSensitive;
    }
}

