package com.cloud.hisavana.sdk.common.util;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.Log;

public class BitmapUtil {


    /**
     * 安比例缩放图片
     *
     * @param origin
     * @param ratio
     * @return
     */
    public static Bitmap scaleBitmap(Bitmap origin, float ratio) {
        Bitmap mewBitmap = null;
        if (origin == null) {
            return null;
        }
        try {
            int width = origin.getWidth();
            int height = origin.getHeight();
            Matrix matrix = new Matrix();
            matrix.postScale(ratio, ratio);
            mewBitmap = Bitmap.createBitmap(origin, 0, 0, width, height, matrix, false);
        }catch (Throwable e){
            AdLogUtil.LOG.e(Log.getStackTraceString(e));
        }
        return mewBitmap;
    }

}
