package com.cloud.hisavana.sdk.ad.base;
/* Top Secret */

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.activity.TAdExposureActivity;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tracking.TrackingManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.SensitiveUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;


/**
 * 广告封装工具类
 *
 * @author $韦明微
 * @data 2016/11/25
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class PlatformUtil {

    private static TaNativeInfo extTAd(AdsDTO adItem) {
        TaNativeInfo nativeInfo = new TaNativeInfo();

        // 埋点用的
        nativeInfo.adItem =adItem;

        if(adItem == null || adItem.nativeBean == null){
            nativeInfo = null;
            return nativeInfo;
        }
        try {
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            adItem.uuid = uuid;
            nativeInfo.uuid = uuid;
            nativeInfo.setSequenceId(String.valueOf(adItem.getId()));
            nativeInfo.setVer(adItem.nativeBean.version);
            nativeInfo.setCtatext(adItem.nativeBean.button != null ? adItem.nativeBean.button.text : "");
            nativeInfo.setDescription(adItem.nativeBean.descript != null ? adItem.nativeBean.descript.text : "");
            nativeInfo.setTitle(adItem.nativeBean.title != null ? adItem.nativeBean.title.text : "");
            nativeInfo.setPrice(String.valueOf(adItem.getPrice()));
            nativeInfo.setRating(String.valueOf(adItem.nativeBean.getRating()));

            AdImage image = new AdImage();
            if (adItem.nativeBean.mainImages != null
                    && adItem.nativeBean.mainImages.size() > 0
                    && adItem.nativeBean.mainImages.get(0) != null){
                image.setH(adItem.nativeBean.mainImages.get(0).height);
                image.setW(adItem.nativeBean.mainImages.get(0).height);
                image.setImgUrl(adItem.nativeBean.mainImages.get(0).url);
            }else{
                image.setH(0);
                image.setW(0);
                image.setImgUrl("");
            }
            nativeInfo.setImage(image);

            //icon
            AdImage icon = new AdImage();
            icon.setH(adItem.nativeBean.logo == null ? 0 : adItem.nativeBean.logo.height);
            icon.setW(adItem.nativeBean.logo == null ? 0 : adItem.nativeBean.logo.width);
            icon.setImgUrl(adItem.nativeBean.logo == null ? "" : adItem.nativeBean.logo.url);
            nativeInfo.setIconImage(icon);

            //adchoice
            nativeInfo.acImageUrl = adItem.adChoiceImageUrl == null ? "" : adItem.adChoiceImageUrl;
            nativeInfo.acClickUrl = adItem.adChoiceClickUrl == null ? "" : adItem.adChoiceClickUrl;
        }catch (Throwable e){
            AdLogUtil.ADX.e(Log.getStackTraceString(e));
            nativeInfo = null;
        }
        return nativeInfo;
    }

    /**
     * 查找对应的adBean
     *
     * @param nativeInfo
     * @return AdBean
     */
    public static AdsDTO getAdBean(TaNativeInfo nativeInfo, List<AdsDTO> adBeans) {
        if (nativeInfo != null) {
            if (adBeans != null && !adBeans.isEmpty()) {
                for (AdsDTO item : adBeans) {
                    if (item != null && nativeInfo.uuid.equals(item.uuid)) {
                        item.isACReady = nativeInfo.isACReady;
                        return item;
                    }
                }
            }
        }
        return null;
    }

    /**
     * 获取多个Native的信息
     * */
    public static List<TaNativeInfo> getTadNativeInfoList(List<AdsDTO> items) {
        List<TaNativeInfo> infoList = new ArrayList<>();
        for (AdsDTO adItem : items) {
            if(adItem == null){
                continue;
            }
            TaNativeInfo nativeInfo = extTAd(adItem);
            if(nativeInfo == null){
                continue;
            }
            if (SensitiveUtil.isSensitive(nativeInfo)) {
                continue;
            }
            infoList.add(nativeInfo);
        }
        return infoList;
    }

    /**
     * 所有的点击事件都走这一个方法
     *
     * 1.有deepLinkUrl，使用deepLinkUrl打开 ；
     * 2.没有deepLinkUrl使用webview打开
     * */
    public static boolean startActivity(Context context, AdsDTO adItem, int adType, String admLdp, DownUpPointBean pointBean) {

        if(context == null){
            AdLogUtil.ADX.e("context is null");
            return false;
        }
        final boolean newTask = (context == context.getApplicationContext() ? true :false);

        if(adItem == null){
            AdLogUtil.ADX.e("adItem is null");
            return false;
        }

        // 只要点击了 就发送请求  adItem 判空 外面已经判断了
        TrackingManager.clickTrackingUrlsExposure(adItem.clickTrackingUrls);

        String landingUrl = !TextUtils.isEmpty(admLdp) ? admLdp : adItem.landingPageUrl;
        AdLogUtil.ADX.e("landing url is : "+landingUrl);
        if (!TextUtils.isEmpty(adItem.deepLinkUrl)) {
            Intent intent = new Intent();
            Uri content_uri = Uri.parse(adItem.deepLinkUrl);
            intent.setData(content_uri);
            intent.setAction("android.intent.action.VIEW");
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            List<ResolveInfo> activities = context.getPackageManager().queryIntentActivities(intent, 0);

            if (activities.size() > 0) {
                boolean flag = true;
                try {
                    context.startActivity(intent);
                    // Track --> 有deeplink
                    TrackingManager.deepLinkUrlExposure(adItem.landingPageUrl,pointBean,null);
                }catch (Throwable e){
                    AdLogUtil.ADX.e("deepLinkUrl error - " + Log.getStackTraceString(e));
                    flag = false;
                }
                if(flag){
                    return true;
                }
            }else {
                AdLogUtil.ADX.e("deepLinkUrl error - activities.size = 0");
            }
        }
        if (!TextUtils.isEmpty(landingUrl) && (landingUrl.startsWith("http") || landingUrl.startsWith("https://"))) {
            startPageByWebView(context,landingUrl,newTask,true,pointBean);
            return true;
        }
        else {
            AdLogUtil.ADX.e( "Both deepLinkUrl and landing page is null");
            return false;
        }

    }
    /**
     * 用于adchoices
     * */
    public static void startPageByWebView(Context context, String url) {
        startPageByWebView(context,url,true,false,null);
    }

    /**
     * 广告的点击 和 adChoices都用的同一个
     *
     * @param context
     * @param url
     * @param newTask
     * @param isAdClick
     */
    public static void startPageByWebView(Context context, String url,boolean newTask,boolean isAdClick,DownUpPointBean pointBean){
        AdLogUtil.ADX.d( "Start page with WebView.");
        Intent intent = new Intent(context, TAdExposureActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("url", url);
        if (isAdClick){
            bundle.putSerializable("pointBean",pointBean);
            bundle.putBoolean("isAdClick", true);
        }
        intent.putExtras(bundle);
        if(newTask){
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }


    public static void startPageByBrowser(Context context, String url){
        boolean isOk = startPageWithChrome(context, url,true);
        if(!isOk) {
            AdLogUtil.ADX.d( "Start page with Chrome Browser failed,Start default Browser.");
            startDefaultBrowser(context,url,true);
        }
    }

    private static boolean startDefaultBrowser(Context context,String landingUrl,boolean newTask){
        try {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            Uri content_uri = Uri.parse(landingUrl);
            intent.setData(content_uri);
            if(newTask){
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            }
            context.startActivity(intent);
            return true;
        }catch (Throwable e){
            AdLogUtil.ADX.e( e.getLocalizedMessage());
            return false;
        }

    }

    /**
     * 开启activity
     *
     * @param context
     * @param landingUrl
     */
    private final static String DEFAULT_BROWSER_PACKAGE = "com.android.chrome";

    private static boolean startPageWithChrome(Context context, String url,boolean newTask) {
        boolean isOk = true;
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            intent.setPackage(DEFAULT_BROWSER_PACKAGE);
            if(newTask){
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            }
            context.startActivity(intent);
        }catch (Throwable e1){
            isOk = false;
        }
        return isOk;
    }


    public static String getRealUrl(String url) {
        String realUrl = "";
        if (!TextUtils.isEmpty(url)) {
            realUrl = url.substring(12);
        }
        return realUrl;
    }
}
