package com.cloud.hisavana.sdk.common.adapter;

import android.content.Context;
import android.support.annotation.NonNull;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.api.view.AAdChoicesView;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;

/**
 * Created by jianbing.yu on 2019/3/26.
 */

public interface IAdPoly {
    void setAdListener(@NonNull InternalAdListener bridgeListener);

    boolean loadAd();

    void setPlacementId(String placementId);

    void destroy();

    void impressionTrack(AdsDTO adBean);

    boolean startLandingPage(Context context, String admLandingUrl, AdsDTO adBean, DownUpPointBean pointBean);

    /**
     * 获取广告缓存剩余时间，单位为毫秒
     *
     * @return 剩余时间
     */
    long getResidualExpirationTime();

    AAdChoicesView getAdChoicesView(Context context, AdsDTO adsDTO);

    AAdChoicesView getAdChoicesView(Context context, AdsDTO adsDTO, boolean isBig);

    /**
     *
     * @param context
     * @param adsDTO
     * @param isBig  判断大小是24或者15
     * @param isNative 判断是否需要是native广告，native广告每次返回新的adchoiceview
     * @return
     */
    AAdChoicesView getAdChoicesView(Context context, AdsDTO adsDTO, boolean isBig,boolean isNative);
}
