package com.cloud.hisavana.sdk.common.athena;

import android.os.Bundle;

import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.common.util.GPSTracker;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.athenacust.AthenaCust;

/**
 * Created by wenjing.luo on 2021/8/24.
 */

public class AthenaTracker {

    /**
     * @return 获取公参
     */
    public static Bundle getBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("session_id", PostConstant.getSessionId());
        bundle.putString("sdk_version", PostConstant.getSdkVersion());
        bundle.putString("user_agent", PostConstant.getUserAgent());
        bundle.putInt("type", PostConstant.getType());
        bundle.putString("make", PostConstant.getMake());
        bundle.putString("ostype", "Android");

        bundle.putString("imei_sha1", PostConstant.getImeiSha1());
        bundle.putString("imei_md5", PostConstant.getImeiMd5());
        bundle.putString("androidId_sha1", PostConstant.getAndroidIdSha1());
        bundle.putString("androidId_md5", PostConstant.getAndroidIdMd5());

        bundle.putInt("screen_width", PostConstant.getScreenWidth());
        bundle.putInt("screen_height", PostConstant.getScreenHeight());
        bundle.putInt("screen_density", PostConstant.getScreenDensity());

        bundle.putString("base_station", DeviceUtil.getGsmCellLocation());
        GPSTracker gps = new GPSTracker();
        bundle.putDouble("latitude", gps.getLatitude());
        bundle.putDouble("longitude", gps.getLongitude());
        bundle.putLong("coordtime", gps.getCoordTime());

        bundle.putString("imsi", PostConstant.getImsi());
        bundle.putString("mac", PostConstant.getMac());

        return bundle;
    }


    /**
     * @param info
     */
    public static void track(AdsDTO info) {
        //公参 SDK自行上报
        Bundle bundle = getBundle();

        //事件参数
        bundle.putString("request_id", info.rid);
        bundle.putString("code_seat_id", info.codeSeatId);
        bundle.putInt("code_seat_type", info.getCodeSeatType());
        bundle.putInt("cache_time", info.getCacheTime());//缓存时长：开屏-4、其他-1 （小时）
        bundle.putInt("id", info.getId());
        bundle.putLong("advertiser_id", info.getAdvertiserId());//广告主id
        bundle.putLong("plan_id", info.getPlanId());//计划id
        bundle.putLong("ad_group_id", info.getAdGroupId());//广告组id
        bundle.putLong("ad_creative_id", info.getAdCreativeId());//广告创意id
        bundle.putFloat("price", info.getPrice());
        bundle.putString("package_name", info.packageName);
        bundle.putString("click_url", info.landingPageUrl);
        bundle.putString("deep_link_url", info.deepLinkUrl);
        bundle.putString("tracking_secret_key", info.showTrackingSecretKey);//曝光加密串
        bundle.putString("default_ad_expiration_time", info.defaultAdExpirationTime);
        bundle.putInt("default_ad_show_count", info.getDefaultAdShowCount());
        bundle.putInt("is_default_ad_first_show", info.getIsDefaultAdFirstShow());//是否初次曝光（仅在打底广告时记录）
        bundle.putString("image_url", info.imageUrl);
        bundle.putInt("image_width", info.getImageWidth());
        bundle.putInt("image_height", info.getImageHeight());
        if (info.nativeBean != null) {
            bundle.putString("version", info.nativeBean.version);
            bundle.putInt("rating", info.nativeBean.getRating());
            if (info.nativeBean.title != null) {
                bundle.putString("title_text", info.nativeBean.title.text);
                bundle.putString("descript_text", info.nativeBean.descript.text);
            }
            if (info.nativeBean.button != null) {
                bundle.putString("button_text", info.nativeBean.button.text);
            }
            if (info.nativeBean.logo != null) {
                bundle.putString("logo_url", info.nativeBean.logo.url);
                bundle.putInt("logo_width", info.nativeBean.logo.width);
                bundle.putInt("logo_height", info.nativeBean.logo.height);
            }
            //todo native多条待完善
            if (info.nativeBean.mainImages != null && info.nativeBean.mainImages.size() > 0) {
                bundle.putString("main_image_url", info.nativeBean.mainImages.get(0).url);
                bundle.putInt("main_image_width", info.nativeBean.mainImages.get(0).width);
                bundle.putInt("main_image_height", info.nativeBean.mainImages.get(0).height);
            }
        }
        bundle.putLong("login_time", System.currentTimeMillis());//日志时间戳
        bundle.putInt("is_default_ad", info.getIsDefaultAd());
        bundle.putInt("actual_show_rate", info.getActualShowRate());//广告素材实际曝光比例
        bundle.putLong("show_ts", System.currentTimeMillis());//广告曝光时时间戳
        bundle.putInt("is_effective_show", info.getIsEffectiveShow());//是否有效曝光 1/0 1=有效 0=无效
        bundle.putString("app_id", SspAd.AppId);
        if (SspAd.isTestRequest()) {
            bundle.putInt("is_test_request", 1); // 是否测试请求   1=是 0=否        int
        } else {
            bundle.putInt("is_test_request", 0);
        }
        new AthenaCust(PostConstant.EVENT, PostConstant.TID).trackCommon(bundle, null).submit();
    }


    // 下载途径
    public static final int DOWNLOAD_WAY_HTTP_URL_CONNECTION = 1;
    public static final int DOWNLOAD_WAY_OKHTTP = 2;

    // 下载状态
    public static final int M_STATUS_STAR = 1;
    public static final int M_STATUS_SUCCESS = 2;
    public static final int M_STATUS_ERROR = 3;

    // 下载类型
    public static final int M_TYPE_LOGO = 1;
    public static final int M_TYPE_LARGE_IMG = 2;

    /**
     * SSP SDK 物料加载日志
     *
     * @param info         广告详情
     * @param download_way 下载方式 1.HttpUrlConnection 2.Okhttp  int
     * @param m_status     物料事件状态  1=开始加载 2=加载成功 3=加载失败 int
     * @param errorcode    失败原因 string
     * @param m_type       物料类型 1=logo 2=大图 int
     */
    public static void trackImageDownload(AdsDTO info, int download_way, int m_status, String errorcode, int m_type) {

        if (null == info) {
            AdLogUtil.imgLog("SSP SDK 物料加载日志 --> info==null  download_way = "
                    + download_way + " m_status = " + m_status + " m_type = " + m_type);
            return;
        }

        AdLogUtil.imgLog("SSP SDK 物料加载日志 --> download_way = "
                + download_way + " m_status = "
                + m_status + " m_type = " + m_type + " info = " + info.toString());

        //公参 SDK自行上报
        Bundle bundle = getBundle();

        //事件参数
        bundle.putString("request_id", info.rid);
        bundle.putString("code_seat_id", info.codeSeatId);
        bundle.putInt("code_seat_type", info.getCodeSeatType());
        bundle.putLong("advertiser_id", info.getAdvertiserId());
        bundle.putLong("plan_id", info.getPlanId());
        bundle.putLong("ad_group_id", info.getAdGroupId());
        bundle.putLong("ad_creative_id", info.getAdCreativeId());
        bundle.putString("package_name", info.packageName);
        bundle.putString("image_url", info.getImageUrl());
        bundle.putInt("image_width", info.getImageWidth());
        bundle.putInt("image_height", info.getImageHeight());
        bundle.putLong("login_time", System.currentTimeMillis());//日志时间戳
        bundle.putInt("is_default_ad", info.getIsDefaultAd());

        // 自定义字段
        bundle.putInt("download_way ", download_way); // 下载方式 1.HttpUrlConnection 2.Okhttp  int
        bundle.putInt("m_status", m_status); // 物料事件状态  1=开始加载 2=加载成功 3=加载失败 int
        bundle.putString("error_code", errorcode); // 失败原因 string
        bundle.putInt("m_type", m_type); // 物料类型 1=logo 2=大图 int
        new AthenaCust(PostConstant.EVENT_IMG, PostConstant.TID).trackCommon(bundle, null).submit();
    }
}
