package com.cloud.hisavana.sdk.common.http;

import android.text.TextUtils;

import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.sign.HttpSigner;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.HttpClient;
import com.transsion.http.impl.StringCallback;

import javax.net.ssl.SSLSocketFactory;


/**
 * Created by peng.sun on 2017/6/19.
 */

public class AdServerRequest extends RequestBase<CommonResponseListener> {
    private String mPlacementid = "0";
    private String mUrl = "";
    private boolean mIsDebug = false;
    private SSLSocketFactory mSSLSocketFactory = null;
    private IAdPostBody mPostBody = null;

    public AdServerRequest setPostBody(IAdPostBody postBody) {
        this.mPostBody = postBody;
        return this;
    }

    public AdServerRequest setListener(CommonResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public AdServerRequest setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public AdServerRequest setDebug(boolean isDebug){
        this.mIsDebug = isDebug;
        return this;
    }

    public AdServerRequest setSSLSocketFactory(SSLSocketFactory sslSocketFactory){
        this.mSSLSocketFactory = sslSocketFactory;
        return this;
    }

    public AdServerRequest setPlacementId(String pid){
        this.mPlacementid = pid;
        return this;
    }
    @Override
    protected void netRequestPosExecute() {
        TranssionPoolManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                /**
                 * 发起网络请求
                 */
                sendRequestToServer();
//                sendRequestToServer_OkHttp();
            }
        });
    }

    public interface IAdPostBody{
        String getPostBody();
    }

    /**
     * 发送数据
     */

    private void sendRequestToServer() {
        String postBodyString = mPostBody.getPostBody();
        try {
            AdLogUtil.netLog( "full url:=" + mUrl);
            AdLogUtil.netLog( "content=" + postBodyString.trim());

            if (!TextUtils.isEmpty(mUrl)) {
                if (mListener != null) {
                    mListener.onServerRequestStart(Constants.LoadType.NET);
                }
                HttpSigner.setTest(AdxServerConfig.getAppModle() != AdxServerConfig.RELEASE);
                String signStr = HttpSigner.doSign("post","","application/json",mUrl,postBodyString);
                HttpClient.postJson()  //必须方法体
                        .log(mIsDebug)
                        .sslSocketFactory(mSSLSocketFactory)  //Tan 需要私有证书校验,Adx不需要
                        .content(postBodyString) //必须方法体，上传的String类型的数据文本，目前只提供上传String接口
                        .connectTimeout(TIMEOUT_IN_MILLIONS)   //网络连接超时时间，单位毫秒，非必须默认10s
                        .readTimeout(TIMEOUT_IN_MILLIONS)      //读取数据超时时间，单位毫秒，非必须默认10s
                        .addHeader("x-tr-signature",signStr)
                        .url(mUrl)
                        .addHeader("Accept-Timezone", "UTC")
                        .build()
                        .execute(new StringCallback(true) {
                                     @Override
                                     public void onSuccess(final int statusCode, String response) {
                                         AdLogUtil.netLog( "status code:=" + statusCode + "  response =" + response);
                                         if (!TextUtils.isEmpty(response)) {
                                             if (mListener != null) {
                                                 mListener.onServerRequestSuccess(statusCode, response);
                                             }
                                         } else {
                                             if (mListener != null) {
                                                 mListener.onServerRequestFailure(TaErrorCode.HTTP_RESPONSE_ERROR.getErrorCode(), TaErrorCode.HTTP_RESPONSE_ERROR.getErrorMessage(), null);
                                             }
                                         }
                                     }

                                     @Override
                                     public void onFailure(int statusCode, String response, Throwable throwable) {
                                         boolean isNeedRetry = HttpSigner.needRetryForTimeIssue(statusCode,response);
                                         if(isNeedRetry){
                                             sendRequestToServer();
                                             return;
                                         }
                                         AdLogUtil.netLog( "error statusCode:=" + statusCode + " ," +
                                                 "reponse: = "+response+",error message = " + throwable.getMessage());
                                         if (mListener != null) {
                                             mListener.onServerRequestFailure(statusCode, response, throwable);
                                         }
                                     }
                                 }

                        );
            }

        } catch (Throwable e) {
            AdLogUtil.LOG.e( e.getMessage());
            AdLogUtil.netLog("sendRequestToServer --> "+e.getMessage());
            if (mListener != null) {
                mListener.onServerRequestFailure(new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE, e.getMessage()));
            }
        }
    }
}
