package com.cloud.hisavana.sdk.common.http.listener;

import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.json.Tson;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;


/**
 * Created by peng.sun on 2017/6/20.
 */

public abstract class CommonResponseListener<E> extends ResponseBaseListener {

    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String UTF8_BOM = "\uFEFF";

    protected CommonResponseListener() {
        super();
    }

    /**
     * 成功回调
     *
     * @param statusCode
     * @param response
     */
    protected abstract void onRequestSuccess(int statusCode, E response);

    public void onServerRequestSuccess(int statusCode, String response) {
        parseResponse(statusCode, response);
    }

//    @Override
//    public void onServerRequestSuccess(int statusCode, byte[] responseBody) {
//        String responseString = null;
//        try {
//            responseString = getResponseString(responseBody, DEFAULT_CHARSET);
//        } catch (UnsupportedEncodingException e) {
//            e.printStackTrace();
//        }
//        parseResponse(statusCode, responseString);
//    }

    private void parseResponse(final int statusCode, final String responseString) {
        try {
            AdLogUtil.ADX.d( "post responseString :"+ responseString);
            Type superclass = CommonResponseListener.this.getClass().getGenericSuperclass();
            if (!(superclass instanceof ParameterizedType)) {
                throw new RuntimeException("Missing type parameter.");
            }
            ParameterizedType parameterized = (ParameterizedType) superclass;
            Type type = parameterized.getActualTypeArguments()[0];


            E bean = null;
            if ("class java.lang.String".equals(type.toString())) {
                bean = (E) responseString;
            } else {
                if (type instanceof Class) {
                    bean = Tson.fromJson(responseString, (Class<E>) type);
                }
            }
            final E final_bean = bean;

            if (handler != null) {
                this.handler.post(new Runnable() {
                    @Override
                    public void run() {
                        onRequestSuccess(statusCode, final_bean);
                    }
                });
            } else {
                onRequestSuccess(statusCode, final_bean);
            }
        } catch (Throwable e) {
            e.printStackTrace();
            AdLogUtil.netLog("解析网络请求数据异常 --> CommonResponseListener --> parseResponse --> catch");
            onRequestError(TaErrorCode.AD_DATA_PARSE_RESPONSE_ERROR);
        }
    }

    /**
     * 辅助方法不做修改
     *
     * @param stringBytes
     * @param charset
     * @return
     * @throws UnsupportedEncodingException
     */
    private String getResponseString(byte[] stringBytes, String charset) throws UnsupportedEncodingException {
        String toReturn = (stringBytes == null) ? null : new String(stringBytes, charset);
        if (toReturn != null && toReturn.startsWith(UTF8_BOM)) {
            return toReturn.substring(1);
        }
        return toReturn;
    }
}
