package com.cloud.hisavana.sdk.common.util;
/* Top Secret */

import static android.content.Context.LOCATION_SERVICE;

import android.annotation.SuppressLint;
import android.location.Location;
import android.location.LocationManager;

import com.transsion.core.CoreUtil;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * usage
 *
 * @author $韦明微
 * @data 2016/11/25
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class GPSTracker {
    private Location location;
    private double latitude;
    private double longitude;
    private int accu = 0;
    private long coordTime = 0;
    private String coordTimeStr = "";

    protected LocationManager locationManager;


    public GPSTracker() {
        getLocation();
    }

    public double getLongitude() {
        return longitude;
    }

    public double getLatitude() {
        return latitude;
    }

    public int getAccu() {
        return accu;
    }

    public long getCoordTime() {
        return coordTime;
    }
    public String getCoordTimeStr() {
        return coordTimeStr;
    }
    @SuppressLint("MissingPermission")
    private void getLocation() {
        try {
            if (CoreUtil.getContext() != null) {
                locationManager = (LocationManager) CoreUtil.getContext().getSystemService(LOCATION_SERVICE);
                // getting GPS status
                boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
                // getting network status
                // flag for network status
                boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);

                if (!isGPSEnabled && !isNetworkEnabled) {
                    // location service disabled
                    return;
                } else {
                    boolean canGetLocation = true;
                    // if GPS Enabled get lat/long using GPS Services
                    if (isGPSEnabled) {
                        if (locationManager != null) {
                            AdLogUtil.LOG.d("Positioning through the GPS");
//                            if ( CoreUtil.getContext().checkSelfPermission(Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
//                                    && checkSelfPermission(Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
//                                return;
//                            }
                            location = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
                            updateGPSCoordinates(location);
                        }
                    }
                    // First get location from Network Provider
                    if (isNetworkEnabled) {
                        if (location == null) {
                            AdLogUtil.LOG.d( "Positioning through the network");
                            if (locationManager != null) {
                                location = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
                                updateGPSCoordinates(location);
                            }
                        }
                    }
                }
            }
        } catch (Throwable e) {
            AdLogUtil.LOG.d( "Location Impossible to connect to LocationManager");
        }
        if (location != null) {
            updateGPSCoordinates(location);
        }
    }

    private void updateGPSCoordinates(Location location) {
        if (location != null) {
            /**
             * because of time consummation, do not get country code
             * @by 王纪清 on 2017/4/17.
             */
            latitude = location.getLatitude();
            longitude = location.getLongitude();
            accu = (int) location.getAccuracy();
            coordTime = location.getTime();
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS Z");
                Date date = new Date(coordTime);
                coordTimeStr = format.format(date);
            }catch (Exception e){
                AdLogUtil.ADX.e(e.getMessage());
            }
        }
    }
}