package com.cloud.hisavana.sdk.internal.native_;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;

import com.cloud.hisavana.sdk.ad.base.AdxAdFactory;
import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.api.view.AAdChoicesView;
import com.cloud.hisavana.sdk.api.view.SspNativeView;
import com.cloud.hisavana.sdk.common.adapter.INative;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.callback.INativeBridge;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSession;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSessionManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.EmptyUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.internal.base.BaseAd;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/2/25.
 */

public class TranNative extends BaseAd implements INativeBridge {
    private NativeGemini mPlatform;

    private List<AdsDTO> mAdBeans;
    private INative mNative;

    private boolean isLoading;
    private boolean unifiedCallback = true;
    //20210923 imageurl加载不成功时候，不显示native广告，所以把imageurl和icon的加载分开
    private int fillType = AdsConfig.FillType.IMAGE;

    public TranNative(String placementId) {
        super(Constants.AdType.NATIVE, placementId);
        mNative = AdxAdFactory.newInstance().getNative(placementId);
        mNative.setAdListener(mInternalListener);
        mPlatform = new NativeGemini(this);
    }

    @Override
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
        mNative.setPlacementId(placementId);
    }

    public void setAdCount(int adCount) {
        mNative.setAdCount(adCount);
    }

    @Override
    protected boolean loadPolyAd() {
        return isLoading = mNative.loadAd();
    }


    @Override
    protected CallbackStub callbackStub() {
        return mStub;
    }

    private CallbackStub mStub = new CallbackStub() {

        /**
         * 网络请求 成功回调
         */
        @Override
        protected void onAdResponse(List<AdsDTO> adBeanList) {
            destroyMeasureSessions();
            mAdBeans = adBeanList;
            loadPlatformAd();
        }

        @Override
        protected void onAdTimeout() {
            if (mPlatform != null && EmptyUtil.isCollectionNotEmpty(mPlatform.getNativeInfos())) {
                if (mPlatform.getNativeInfos().size() > 1) {
                    mInternalListener.onAdLoaded(mPlatform.getNativeInfos());
                } else {
                    setOneByOne(false);
                    mInternalListener.onAdLoaded(mPlatform.getNativeInfos());
                }
            } else {
                super.onAdTimeout();
            }
        }

        @Override
        protected void onAdLoaded(List<TaNativeInfo> nativeInfos) {
            for (TaNativeInfo nativeInfo : nativeInfos) {
                if (nativeInfo != null) {
                    nativeInfo.nativeBridge = TranNative.this;
                }
            }
        }
    };

    List<AdsDTO> adBeans() {
        return mAdBeans;
    }

    INative polyNative() {
        return mNative;
    }

    private void setupViews(@NonNull View view, TaNativeInfo adInfo, AAdChoicesView adChoicesView) {
        if (view != null && view instanceof SspNativeView) {
            ((SspNativeView) view).setupViews(adInfo, adChoicesView);
        } else if (view != null && view instanceof ViewGroup) {
            View tmp;
            for (int index = 0; index < ((ViewGroup) view).getChildCount(); index++) {
                tmp = ((ViewGroup) view).getChildAt(index);
                if (tmp != null && tmp instanceof SspNativeView) {
                    ((SspNativeView) tmp).setupViews(adInfo, adChoicesView);
                    break;
                } else if (tmp != null && tmp instanceof ViewGroup) {
                    setupViews(tmp, adInfo, adChoicesView);
                }
            }
        }
    }

    //TaNativeInfo nativeInfo;

    public void registerViews(@NonNull ViewGroup view, List<View> adContains, TaNativeInfo adInfo) {
        Preconditions.checkIsOnMainThread();
        if (mPlatform != null && adInfo != null) {
            TaNativeInfo nativeInfo = adInfo;
            AdsDTO adBean = PlatformUtil.getAdBean(nativeInfo, mAdBeans);
            if (adBean == null) {
                AdLogUtil.LOG.e("adItem is null");
                return;
            }
            if (!mLoaded) {
                AdLogUtil.LOG.e("Ad not loaded.");
                return;
            }
            //显示view
            setupViews(view, adInfo, mNative.getAdChoicesView(view.getContext(), PlatformUtil.getAdBean(adInfo, mAdBeans)));
            boolean isAdValid = isAdValid(nativeInfo);
            //打底广告是否有效，是看打底广告的有效期
            if (isDefaultAd) isAdValid = true;
            /**广告开启了复用，要注意需要将前面已经展示的广告结果改为false,且重新添加广告展示监测*/
            if (isAdValid && !nativeInfo.showed) {
                doImpressionLogic(view, adBean);
            } else if (isAdValid) {
                nativeInfo.showed = false;
                destroySingleMeasureSession(nativeInfo);
                doImpressionLogic(view, adBean);
            } else {
                AdLogUtil.ADX.e("ad not condition to use");
            }
            mPlatform.registerViewForInteraction(view, adContains, nativeInfo, adBean);
            AdLogUtil.LOG.d("Native Ad start registered");
            if (View.GONE == view.getVisibility()) {
                view.setVisibility(View.VISIBLE);
            }
        }
    }

    private void doImpressionLogic(@NonNull View view, AdsDTO adBean) {
        AdLogUtil.LOG.d("current native did not showed...");
        MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(adBean);
        session.registerView(view, impressionListener);
    }

    private MeasureSession.AdImpressionListener impressionListener = new MeasureSession.AdImpressionListener<AdsDTO>() {
        @Override
        public void onViewImpressed(AdsDTO nativeInfo) {
            if (mPlatform != null && nativeInfo != null) {
                //mPlatform.adImpression(nativeInfo);
                mPlatform.adImpression(null);
            }
        }
    };

    private void unregisterViews(TaNativeInfo nativeInfo) {
        if (mPlatform != null) {
            mPlatform.unregisterView(nativeInfo);
        }
    }

    /**
     * 获取广告item
     */
    private void loadPlatformAd() {
        AdLogUtil.LOG.d("loadPlatformAd start load ad");
        boolean isResetTimer = mPlatform.loadAd();
        if (isResetTimer) {
            resetTimerTask();
            runTimerTask();
        }
    }

    private void destroyMeasureSessions() {
        if (mPlatform != null && mPlatform.getNativeInfos() != null) {
            for (TaNativeInfo nativeInfo : mPlatform.getNativeInfos()) {
                destroySingleMeasureSession(nativeInfo);
            }
        }
    }

    private void destroySingleMeasureSession(TaNativeInfo nativeInfo) {
        if (nativeInfo != null) {
            // TODO 注销 ===================
            AdsDTO adBean = PlatformUtil.getAdBean(nativeInfo, mAdBeans);
            MeasureSessionManager.getInstance().destroySession(adBean);
        }
    }

    @Override
    public void destroy() {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                destroyMeasureSessions();
                mNative.destroy();
                TranNative.super.destroy();
                mPlatform.destroy();
            }
        });
    }

    @Override
    public int getAdType() {
        return Constants.AdType.NATIVE;
    }

    @Override
    public void onNativeInfoDestroy(final TaNativeInfo nativeInfo) {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                destroySingleMeasureSession(nativeInfo);
                unregisterViews(nativeInfo);
            }
        });
    }

    @Override
    public boolean isAdValid(TaNativeInfo nativeInfo) {
        AdsDTO adBean = PlatformUtil.getAdBean(nativeInfo, mAdBeans);
        if (adBean != null) {
            boolean isAdValid = System.currentTimeMillis() - adBean.getFill_ts() <= (adBean.getCacheTime() * 60 * 1000);
            AdLogUtil.ADX.w("isAdValid-" + isAdValid + " -now-" + System.currentTimeMillis() + "-load-" + adBean.getFill_ts() + "-cachetime-" + adBean.getCacheTime() * 60 * 1000);
            return isAdValid;
        }
        return false;
    }

    public boolean isLoading() {
        return isLoading;
    }

    void setLoading(boolean loading) {
        isLoading = loading;
    }

    boolean isUnifiedCallback() {
        return unifiedCallback;
    }

    int getFillType() {
        return fillType;
    }

    void loadFinished() {
        isLoading = false;
        onLoaded();
    }

    public void downloadMedia(final TaNativeInfo ad) {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                mPlatform.downloadMedia(ad);
            }
        });
    }

    public AAdChoicesView getAdChoicesView(Context context, TaNativeInfo taNativeInfo) {
        return mNative.getAdChoicesView(context, PlatformUtil.getAdBean(taNativeInfo, mAdBeans), true, true);
    }
}
