package com.cloud.hisavana.sdk.internal.banner;

import android.content.Context;
import android.graphics.Matrix;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.ad.base.AdxAdFactory;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.api.view.AAdChoicesView;
import com.cloud.hisavana.sdk.common.adapter.IBanner;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSession;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSessionManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DrawableUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.internal.base.BaseAd;
import com.transsion.core.utils.ScreenUtil;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/2/25.
 */

public class TranBanner extends BaseAd {
    BannerGemini mBannerPlatform;
    /**
     * 打点相关
     */
    private AdsDTO mAdBean = null;
    private ViewGroup mViewGroup;
    private Context mContext;
    private View mRenderView = null;
    private IBanner mBanner;
    //ad标识和adchoice的位置
    private int rightMargin;
    private int topMargin;
    private boolean isBig = false;
    public TranBanner(Context context, ViewGroup viewGroup, String placementId) {
        super(Constants.AdType.BANNER, placementId);
        this.mViewGroup = viewGroup;
        this.mContext = context.getApplicationContext();
        mBanner = AdxAdFactory.newInstance().
                getBanner(placementId);
        mBanner.setAdListener(mInternalListener);
        mBannerPlatform = new BannerGemini(this);
    }

    @Override
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
        mBanner.setPlacementId(placementId);
    }

    public boolean isAdValid() {
        if (mAdBean != null) {
            boolean isAdValid = System.currentTimeMillis() - mAdBean.getFill_ts() <= mAdBean.getCacheTime() * 60 * 1000;
            AdLogUtil.LOG.e("isAdValid-" + isAdValid + " -now-" + System.currentTimeMillis() + "-load-" + mAdBean.getFill_ts() + "-cachetime-" + mAdBean.getCacheTime() * 60 * 1000);
            return isAdValid;
        }
        return false;
    }


    @Override
    protected CallbackStub callbackStub() {
        return mStub;
    }

    @Override
    protected boolean loadPolyAd() {
        if (mBanner.loadAd()) {
            if (mViewGroup != null) {
                mViewGroup.removeAllViews();
            }
            return true;
        }
        return false;
    }

    CallbackStub mStub = new CallbackStub() {
        @Override
        protected void onAdResponse(List<AdsDTO> adBeanList) {
            if (mAdBean != null) {
                MeasureSessionManager.getInstance().destroySession(mAdBean);
            }
            mAdBean = adBeanList.get(0);
            if (mAdBean == null) {
                AdLogUtil.LOG.e("mAdBean is null,terminate flow");
                return;
            }

            loadPlatformAd();
        }
    };

    AdsDTO adBean() {
        return mAdBean;
    }

    IBanner polyBanner() {
        return mBanner;
    }

    /**
     * 渲染Banner界面
     */
    private void loadPlatformAd() {
        mRenderView = mBannerPlatform.getBannerView(mContext);
        AdLogUtil.LOG.d("start load ad");
    }

    void attachBannerToViewTree(AdImage adImage) {
        /**
         *  素材比例：3:2；20:3
         *  mAdchoiceView  24  15
         **/
        if (mAdBean == null || mViewGroup == null || mRenderView == null) {
            return;
        }
        final int imageWidth = DrawableUtil.getDrawableWidth(adImage.getDrawable(), 0);
        final int imageHeight = DrawableUtil.getDrawableHeight(adImage.getDrawable(), 0);
        int expectedHeight = (int) (imageHeight * ((float) ScreenUtil.getWinWidth() / imageWidth));
        int expectedWidth = ScreenUtil.getWinWidth();
        AdLogUtil.LOG.d("expectedWidth: " + expectedWidth + " dp,expectedHeight: " + expectedHeight + " dp, screen width is: " + ScreenUtil.getWinWidth());
        mViewGroup.removeAllViews();
        ((RelativeLayout) mViewGroup).setGravity(Gravity.CENTER);
        mViewGroup.addView(mRenderView,
                expectedWidth,
                expectedHeight);
        if (mRenderView instanceof ImageView) {
            ((ImageView) mRenderView).setScaleType(ImageView.ScaleType.FIT_CENTER);
            adImage.attachView((ImageView) mRenderView);
        }
        ViewTreeObserver vto2 = mRenderView.getViewTreeObserver();
        vto2.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                mRenderView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                getDrawablePosition((ImageView) mRenderView);
                if (imageHeight != 0)isBig = imageWidth / imageHeight == 3 / 2;
                //广告来源
                setAdChoice();
                //添加广告标识
                addAdMark();
            }
        });

        if (mViewGroup.getBackground() != null) {
            mViewGroup.getBackground().setAlpha(0);
        }
        mViewGroup.setVisibility(View.VISIBLE);
        AdLogUtil.LOG.d("ad banner show...");
    }

    /**
     * 获取ad标识和adchoice的margin
     *
     * @param v
     */
    private void getDrawablePosition(final ImageView v) {
        // view的实际宽高
        float vWidth = v.getWidth();
        float vHeight = v.getHeight();

        // 得到imageview中的矩阵，准备得到drawable的拉伸比率
        Matrix m = v.getImageMatrix();
        float[] values = new float[10];
        m.getValues(values);

        // drawable的本身宽高
        if(v.getDrawable() == null){
            return;
        }
        float dOriginalWidth = v.getDrawable().getIntrinsicWidth();
        float dOriginalHeight = v.getDrawable().getIntrinsicHeight();
        float dRatio = dOriginalWidth / dOriginalHeight;//如果大于1，表示drawable宽>高

        //Image在绘制过程中的变换矩阵，从中获得x和y方向的缩放系数  value[0],[4]
        //得到drawable的实际显示时的宽高
        int dWidth = (int) (dOriginalWidth * values[0]);
        int dHeight = (int) (dOriginalHeight * values[4]);

        //得到imageview的宽高和drawable的宽高的差值
        float w = vWidth - dWidth;
        float h = vHeight - dHeight;

        topMargin = (int) ((h / 2) + 0.5f);
        rightMargin = (int) ((w / 2) + 0.5f);
    }

    /**
     * 添加广告标识
     */
    private void addAdMark() {
        TextView textView = new TextView(mContext);
        textView.setText(R.string.ad_icon);
        RelativeLayout.LayoutParams params;
        int paddingHor = mContext.getResources().getDimensionPixelOffset(R.dimen.ad_mark_padding_hor);
        int paddingVer = mContext.getResources().getDimensionPixelOffset(R.dimen.ad_mark_padding_ver);
        if (isBig) {
            params = new RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.WRAP_CONTENT, ScreenUtil.dip2px(Constants.adChoiceViewSizeBig));
        } else {
            params = new RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.WRAP_CONTENT, ScreenUtil.dip2px(Constants.adChoiceViewSize));
            textView.setTextSize(10);
            paddingHor = mContext.getResources().getDimensionPixelOffset(R.dimen.ad_mark_padding_hor_6);
        }
        textView.setPadding(paddingHor, paddingVer, paddingHor, paddingVer);
        textView.setTextColor(mContext.getResources().getColor(R.color.ad_text_color));
        textView.setBackgroundColor(mContext.getResources().getColor(R.color.ad_icon_bg));
        textView.setGravity(Gravity.CENTER);
        params.leftMargin = rightMargin + textView.getWidth();
        params.topMargin = topMargin;
        mViewGroup.addView(textView, params);
    }

    /**
     * 广告来源
     */
    private void setAdChoice() {
        //广告宽高比是3/2时 adchoiceview是24  广告宽高比是30/2时 adchoiceview是15
        AAdChoicesView choicesView = mBanner.getAdChoicesView(mContext, mAdBean, isBig);
        if (mViewGroup.indexOfChild(choicesView) < 0) {
            if (choicesView != null) {
                RelativeLayout.LayoutParams params;
                if (choicesView.getLayoutParams() != null) {
                    params = (RelativeLayout.LayoutParams) choicesView.getLayoutParams();
                } else {
                    params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                }
                params.addRule(RelativeLayout.ALIGN_PARENT_END);
                params.rightMargin = rightMargin;
                params.topMargin = topMargin;
                mViewGroup.addView(choicesView, params);
            }
        }
    }

    /**
     * 展示回调
     */
    public void show() {
        Preconditions.checkIsOnMainThread();
        if (mViewGroup == null || mAdBean == null) {
            AdLogUtil.LOG.e("mViewGroup or mAdBean = null");
            return;
        }
        boolean isAdValid = isAdValid();
        //打底广告是否有效，是看打底广告的有效期
        if (isDefaultAd) isAdValid = true;
        if (isAdValid && !mShowed) {
            doImpressionLogic();
        } else if (isAdValid) {
            mShowed = false;
            MeasureSessionManager.getInstance().destroySession(mAdBean);
            doImpressionLogic();
        } else {
            AdLogUtil.LOG.e("ad not condition to use");
        }
    }

    private void doImpressionLogic() {
        if (mRenderView != null && mLoaded && mAdBean != null) {
            MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mAdBean);
            session.registerView(mRenderView, impressionListener);
            mBannerPlatform.showAd();
        } else {
            AdLogUtil.LOG.e("no ad show, set visible gone");
            mViewGroup.setVisibility(View.GONE);
        }
    }

    private MeasureSession.AdImpressionListener impressionListener = new MeasureSession.AdImpressionListener<AdsDTO>() {
        @Override
        public void onViewImpressed(AdsDTO adBean) {
            AdLogUtil.LOG.d("view has impression,start report track---------------------------------");
            if (adListener() != null) {
                adListener().onAdShow();
            }
            //mBannerPlatform.adShowTrack();
        }
    };


    @Override
    public void destroy() {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                mBanner.destroy();
                TranBanner.super.destroy();
                if (mViewGroup != null) {
                    mViewGroup.removeAllViews();
                }
                mBannerPlatform.destroy();
                MeasureSessionManager.getInstance().destroySession(mAdBean);
            }
        });
    }

    @Override
    public int getAdType() {
        return Constants.AdType.BANNER;
    }

}
