package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.internal.banner.TranBanner;

/**
 * Created by jianbing.yu on 2019/2/22.
 */

public class ABannerView extends RelativeLayout {
    private TranBanner mBanner;
    public ABannerView(Context context, String placementId) {
        super(context);
        mBanner = new TranBanner(context,this,placementId);
    }

    /**
     * 构造方法
     *
     * @param context
     * @param attrs
     */
    public ABannerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /**
     * 构造方法
     *
     * @param context
     * @param attrs
     * @param defStyleAttr
     */
    public ABannerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        String placementId = null;
        TypedArray types = context.obtainStyledAttributes(attrs, R.styleable.AdBannerView);
        for (int n = 0; n < types.getIndexCount(); n++) {
            int attr = types.getIndex(n);
            if (attr == R.styleable.AdBannerView_placementId) {
                placementId = types.getString(attr);
            }
        }

        if (types.getIndexCount() > 0) {
            AdLogUtil.LOG.d( "placementId=" + placementId);
        }
        types.recycle();
        mBanner = new TranBanner(context,this,placementId);
    }

    /**
     * 设置placementId
     *
     * @param placementId
     */
    public void setPlacementId(String placementId) {
        if(isNullApi()){
            return;
        }
        mBanner.setPlacementId(placementId);
    }

    public void show(){
        if(isNullApi()){
            return;
        }
        mBanner.show();
    }

    public void setAdRequest(@NonNull TaRequest adRequest) {
        if(isNullApi()){
            return;
        }
        mBanner.setAdRequest(adRequest);
    }

    public boolean isAdValid() {
        if(isNullApi()){
            return false;
        }
        return mBanner.isAdValid();
    }
    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        if(isNullApi()){
            return;
        }
        mBanner.setDefaultAd(isDefaultAd);
    }
    public void loadAd() {
        if(isNullApi()){
            return;
        }
        mBanner.loadAd();
    }

    public void destroy() {
        if(isNullApi()){
            return;
        }
        mBanner.destroy();
    }

    private boolean isNullApi(){
        if(mBanner == null){
            AdLogUtil.LOG.e("no api found");
            return true;
        }
        return false;
    }

}
