package com.cloud.hisavana.sdk.common.http;

import static com.transsion.core.CoreUtil.getContext;

import android.util.Log;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.impl.HttpCallbackImpl;

import java.io.IOException;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by peng.sun on 2017/6/19.
 */

public class DownLoadRequest extends RequestBase<DrawableResponseListener> {

    /**
     * 用于埋点
     */
    private AdsDTO adsDTO;
    //  物料类型 1=logo 2=大图 int
    private int m_type;

    public DownLoadRequest setAdsDTO(AdsDTO ads,int type){
        this.adsDTO=ads;
        this.m_type=type;
        return this;
    }

    private String url = "";
    private int isPreCache = Constants.ImageLoadType.IMAGE_RAM_INCLUDED;

    public DownLoadRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DownLoadRequest setListener(DrawableResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownLoadRequest setPreCache(int preCache) {
        this.isPreCache = preCache;
        return this;
    }

    /**
     * 前期执行检查网络
     */
    public void netRequestPreExecute() {

        if (ADOkHttpClient.getInstance().getOkHttpClient() != null) {
            AdLogUtil.imgLog("媒体使用了 Okhttp");
            try {
                switchOkhttp();
            }catch (Exception e){
                AdLogUtil.imgLog("媒体使用 Okhttp 异常 " + e.getMessage());
                mListener.onServerRequestFailure(new TaErrorCode(0, "Okhttp - " + e.getMessage()));
            }
            return;
        }

        AdLogUtil.imgLog("媒体没有使用 Okhttp 正常走流程 ");

        /**
         * 分发网络请求
         */
        netRequestPosExecute();
    }

    @Override
    protected void netRequestPosExecute() {
        try {
//          .fetchFilePath(true)

            downloadStart(AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION);

            HttpClient.image(getContext())         //必须方法体，需要传入context
                    .log(false)
                    .cache(true)
                    .connectTimeout(TIMEOUT_IN_MILLIONS)   //网络连接超时时间，单位毫秒，非必须默认15s
                    .readTimeout(20 * 1000)      //读取数据超时时间，单位毫秒，20s
                    .url(url)           //必须方法体，传入图片url
                    .build()
                    .execute(new HttpCallbackImpl(true) {
                        @Override
                        public void onSuccess(int statusCode, byte[] data) {
                            if (mListener != null && mListener instanceof DrawableResponseListener) {
                                mListener.onServerRequestSuccess(isPreCache, statusCode, data, null);
                            }
                            downloadSuccess(AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION);
                        }

                        @Override
                        public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                            if (mListener != null) {
                                mListener.onServerRequestFailure(statusCode, bytes, throwable);
                            }
                            downloadError(AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION,throwable.getMessage());
                        }

                        @Override
                        public void onSuccess(int statusCode, byte[] responseBody, final String filePath) {
                            if (mListener != null && mListener instanceof DrawableResponseListener) {
                                mListener.onServerRequestSuccess(isPreCache, statusCode, responseBody, filePath);
                            }
                            downloadSuccess(AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION);
                        }
                    });
        } catch (Throwable e) {
            AdLogUtil.LOG.e(Log.getStackTraceString(e));
        }
    }


    /**
     * 检查一下 媒体使用了 Okhttp 了没有   --> 下面一坨 是接入媒体使用了 Okhttp 之后使用Okhttp 加载图片
     * 不使用直接将下面的代码移除即可。
     *
     * @return true 使用了
     * false 没有使用
     */
    private void switchOkhttp() {

        // 获取全局使用的 OkHttpClient
        OkHttpClient client = ADOkHttpClient.getInstance().getOkHttpClient();

        // 发起请求
        downloadStart(AthenaTracker.DOWNLOAD_WAY_OKHTTP);
        final Request request = new Request.Builder().get().url(url).build();
        client.newCall(request).enqueue(new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                AdLogUtil.imgLog("onFailure_IOException" + e.toString());
                if (mListener != null) {
                    mListener.onServerRequestFailure(new TaErrorCode(0, e.getMessage()));
                }
                downloadError(AthenaTracker.DOWNLOAD_WAY_OKHTTP,e.getMessage());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                if (response != null && response.isSuccessful() && response.body()!=null) {
                    if (response.request() != null) {
                        AdLogUtil.imgLog("onResponse = " + response.request().url());
                    }
                    byte[] bytes = response.body().bytes();
                    //Bitmap bitmap = BitmapFactory.decodeByteArray(bytes, 0, bytes.length);
                    //方法二,可以获取字节流,然后转换成图片
                    //InputStream inputStream = response.body().byteStream();
                    //Bitmap bitmap1 = BitmapFactory.decodeStream(inputStream);

                    if (mListener != null && mListener instanceof DrawableResponseListener) {
                        mListener.onServerRequestSuccess(isPreCache, response.code(), bytes, null);
                    }
                    downloadSuccess(AthenaTracker.DOWNLOAD_WAY_OKHTTP);
                }else{
                    if (mListener != null) {
                        mListener.onServerRequestFailure(new TaErrorCode(0, "response != null && response.isSuccessful() && response.body()!=null"));
                    }
                    downloadError(AthenaTracker.DOWNLOAD_WAY_OKHTTP,"response == null || !response.isSuccessful() || response.body()==null");
                }
            }
        });

    }



    // =============================================================================================


    /**
     * 开始下载 下载成功 下载失败 日志上报
     * info          广告详情
     * download_way 下载方式 1.HttpUrlConnection 2.Okhttp  int
     * m_status     物料事件状态  1=开始加载 2=加载成功 3=加载失败 int
     * errorcode    失败原因 string
     * m_type       物料类型 1=logo 2=大图 int
     */
    private void downloadStart(int download_way){
        AthenaTracker.trackImageDownload(adsDTO,download_way,AthenaTracker.M_STATUS_STAR,"",m_type);
    }

    private void downloadSuccess(int download_way){
        AthenaTracker.trackImageDownload(adsDTO,download_way,AthenaTracker.M_STATUS_SUCCESS,"",m_type);
    }

    private void downloadError(int download_way,String errorMsg){
        AthenaTracker.trackImageDownload(adsDTO,download_way,AthenaTracker.M_STATUS_ERROR,errorMsg,m_type);
    }


}
