package com.cloud.hisavana.sdk.common.http;

/* Top Secret */

import android.text.TextUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

/**
 * usage
 *
 * @author 周粤琦
 * @date 2017/9/6
 * ==================================
 * Copyright (c) 2017 TRANSSION.Co.Ltd.
 * All rights reserved
 */

public class HttpsConfigUtil {
    public static SSLSocketFactory getSSLSocketFactory(String name) {

        if (TextUtils.isEmpty(name)) return null;
//        AdLogUtil.LOG.d( "getSSLSocketFactory name: = " + name);

        InputStream certSteam = null;
        try {
            certSteam = new ByteArrayInputStream(name.getBytes());

            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate cert = factory.generateCertificate(certSteam);

            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("cert", cert);

            String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
            trustManagerFactory.init(keyStore);

            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);

            return sslContext.getSocketFactory();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (CertificateException e) {
            e.printStackTrace();
        } catch (KeyStoreException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (Throwable e) {
            e.printStackTrace();
        } finally {
            try {
                if (certSteam != null) {
                    certSteam.close();
                }
            } catch (Throwable e) {
                e.printStackTrace();
            }

        }
        return null;
    }

    public static TrustManager getTrustManager() {
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
            return trustManagerFactory.getTrustManagers()[0];
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }
}
