package com.cloud.hisavana.sdk.api.config;


import com.cloud.hisavana.sdk.api.listener.TaRequest;

/**
 * @author Connor Lin
 * @date 2020/4/24
 */
public final class AdsConfig {
    public int fillType;
    public int adCount;
    public AdsConfig(int fillType,int adCount){
        this.fillType = fillType;
        this.adCount = adCount;
    }

    public interface FillType {
        int IMAGE = 0;
        int ALL = 1;
        int ICON = 2;
    }

    public interface DownloadType {
        int SINGLE = 0;
        int UNIFIED = 1;
        int ADCHOICE = 2;
        int MEDIA = 3;
    }

    public static final class Builder {
        private TaRequest tAdRequest;
        private int fillType;
        private int adCount = 1;
        public Builder() {}

        public AdsConfig build() {
            return new AdsConfig(fillType,adCount);
        }

        public AdsConfig.Builder fillType(int fillType) {
            this.fillType = fillType;
            return this;
        }

        public AdsConfig.Builder adCount(int adCount) {
            this.adCount = adCount;
            return this;
        }
    }
}
