package com.cloud.hisavana.sdk.common.util;

import android.Manifest;
import android.content.Context;
import android.os.Environment;

import com.transsion.core.CoreUtil;
import com.transsion.core.utils.PermissionUtil;

import java.io.File;

/**
 * @author peng.sun
 * @data 2017/7/5
 * ========================================
 * CopyRight (c) 2017 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class FileUtil {

    /**
     * 获得SDCard/Android/data/你的应用的包名/files/ 路径
     *
     * @return
     */
    public static File getAppDateFilePath() {
        Context context = CoreUtil.getContext();
        if (PermissionUtil.lacksPermissions(Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.READ_EXTERNAL_STORAGE)) {
            return null;
        }
        return context.getExternalFilesDir(null);
    }


    /**
     * 获得SDCard/android/data/你的应用包名/cache/路径
     *
     * @return
     */
    public static File getAppDateCachePath() {
        Context context = CoreUtil.getContext();
        return context.getExternalCacheDir();
    }

    /**
     * 该方法会判断当前sd卡是否存在，然后选择缓存地址
     *
     * @param context
     * @param uniqueName
     * @return
     */
    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath;
        if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
            cachePath = context.getExternalCacheDir().getPath();
        } else {
            cachePath = context.getCacheDir().getPath();
        }
        return new File(cachePath + File.separator + uniqueName);
    }
}
