package com.cloud.hisavana.sdk.ad.base;


import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.ad.AdxBannerView;
import com.cloud.hisavana.sdk.ad.AdxInterstitial;
import com.cloud.hisavana.sdk.ad.AdxNative;
import com.cloud.hisavana.sdk.ad.AdxSplash;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.adapter.IAdFactory;
import com.cloud.hisavana.sdk.common.adapter.IBanner;
import com.cloud.hisavana.sdk.common.adapter.IDataInterface;
import com.cloud.hisavana.sdk.common.adapter.IInterstitial;
import com.cloud.hisavana.sdk.common.adapter.INative;
import com.cloud.hisavana.sdk.common.adapter.ISplash;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/3/11.
 */

public class AdxAdFactory implements IAdFactory {
    private static AdxAdFactory sInstance = null;
    private IDataInterface mDataImpll = null;
    public static IAdFactory newInstance(){
        synchronized(AdxAdFactory.class){
            if(sInstance == null){
                sInstance = new AdxAdFactory();
            }
            return sInstance;
        }
    }


    @Override
    public IBanner getBanner(String placementId) {
        return new AdxBannerView(placementId);
    }

    @Override
    public IInterstitial getInterstitial(String placementId) {
        return new AdxInterstitial(placementId);
    }

    @Override
    public INative getNative(String placementId) {
        return new AdxNative(placementId);
    }

    @Override
    public ISplash getSplash(String placementId) {
        return new AdxSplash(placementId);
    }

    @Override
    public IDataInterface getDataImpl() {
        if(mDataImpll == null){
            return new IDataInterface() {
                @Override
                public boolean requestSplash(String placementId, InternalAdListener listener) {
                    return AdxSplash.SplashNetRequest.loadByNet(placementId, listener);
                }

                @Override
                public boolean cacheSplash(String placementId, AdsDTO adItem) {
                    return AdxSplash.SplashNetRequest.cacheSplash(placementId, adItem);
                }

                @Override
                public boolean cacheSplashList(String placementId, List<AdsDTO> adItem) {
                    return AdxSplash.SplashNetRequest.cacheSplashList(placementId, adItem,true);
                }

                @Override
                public String getSdkVersion() {
                    return BuildConfig.VERSION_NAME;
                }
            };
        }
        return mDataImpll;
    }

}
